/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.AbstractUiModelTest;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegionLink;

public class UiRegionLinkTest
extends AbstractUiModelTest {
    private static final RegionId R1 = RegionId.regionId((String)"r1");
    private static final RegionId R2 = RegionId.regionId((String)"r2");
    private static final DeviceId DEV_X = DeviceId.deviceId((String)"device-X");
    private static final DeviceId DEV_Y = DeviceId.deviceId((String)"device-Y");
    private static final ConnectPoint CP_X = new ConnectPoint((ElementId)DEV_X, PortNumber.P0);
    private static final ConnectPoint CP_Y = new ConnectPoint((ElementId)DEV_Y, PortNumber.P0);
    private static final Link LINK_X_TO_Y = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_X).dst(CP_Y).type(Link.Type.DIRECT).build();

    @Test(expected=NullPointerException.class)
    public void nullPointerRegion() {
        UiRegionLinkTest.title("nullPointerRegion");
        new UiRegionLink(null, null);
    }

    @Test
    public void regionToRegion() {
        UiRegionLinkTest.title("regionToRegion");
        UiLinkId id = UiLinkId.uiLinkId((RegionId)R1, (RegionId)R2);
        UiRegionLink link = new UiRegionLink(null, id);
        UiRegionLinkTest.print("link: %s", link);
        Assert.assertEquals((String)"bad first region", (Object)R1, (Object)link.regionA());
        Assert.assertEquals((String)"bad second region", (Object)R2, (Object)link.regionB());
    }

    @Test(expected=IllegalArgumentException.class)
    public void wrongLinkType() {
        UiRegionLinkTest.title("wrongLinkType");
        UiLinkId id = UiLinkId.uiLinkId((Link)LINK_X_TO_Y);
        new UiRegionLink(null, id);
    }
}

