/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table.cell;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.table.CellFormatter;
import org.onosproject.ui.table.cell.HexLongFormatter;

public class HexLongFormatterTest {
    private CellFormatter fmt = HexLongFormatter.INSTANCE;

    @Test
    public void nullValue() {
        Assert.assertEquals((String)"null value", (Object)"", (Object)this.fmt.format(null));
    }

    @Test
    public void zero() {
        Assert.assertEquals((String)"zero", (Object)"0x0", (Object)this.fmt.format((Object)0L));
    }

    @Test
    public void one() {
        Assert.assertEquals((String)"one", (Object)"0x1", (Object)this.fmt.format((Object)1L));
    }

    @Test
    public void ten() {
        Assert.assertEquals((String)"ten", (Object)"0xa", (Object)this.fmt.format((Object)10L));
    }

    @Test
    public void twenty() {
        Assert.assertEquals((String)"twenty", (Object)"0x14", (Object)this.fmt.format((Object)20L));
    }

    @Test
    public void veryBig() {
        Assert.assertEquals((String)"very big", (Object)"0x7048860f3a38", (Object)this.fmt.format((Object)123456789101112L));
    }

    @Test
    public void maxLong() {
        Assert.assertEquals((String)"max long", (Object)"0x7fffffffffffffff", (Object)this.fmt.format((Object)Long.MAX_VALUE));
    }
}

