/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgprouter;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.bgprouter.IcmpHandler;
import org.onosproject.bgprouter.NextHop;
import org.onosproject.bgprouter.NextHopGroupKey;
import org.onosproject.bgprouter.TunnellingConnectivityManager;
import org.onosproject.config.NetworkConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.packet.PacketService;
import org.onosproject.routing.FibEntry;
import org.onosproject.routing.FibListener;
import org.onosproject.routing.FibUpdate;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.BgpSpeaker;
import org.onosproject.routing.config.Interface;
import org.onosproject.routing.config.InterfaceAddress;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BgpRouter {
    private static final Logger log = LoggerFactory.getLogger(BgpRouter.class);
    private static final String BGP_ROUTER_APP = "org.onosproject.bgprouter";
    private static final int PRIORITY_OFFSET = 100;
    private static final int PRIORITY_MULTIPLIER = 5;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoutingService routingService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoutingConfigurationService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    private ApplicationId appId;
    private final Multiset<IpAddress> nextHopsCount = ConcurrentHashMultiset.create();
    private final Map<IpPrefix, IpAddress> prefixToNextHop = Maps.newHashMap();
    private final Map<IpAddress, Integer> nextHops = Maps.newHashMap();
    private final Multimap<NextHopGroupKey, FibEntry> pendingUpdates = HashMultimap.create();
    private DeviceId deviceId;
    private DeviceId ctrlDeviceId;
    private TunnellingConnectivityManager connectivityManager;
    private DeviceListener deviceListener;
    private IcmpHandler icmpHandler;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(BGP_ROUTER_APP);
        this.getDeviceConfiguration(this.configService.getBgpSpeakers());
        this.connectivityManager = new TunnellingConnectivityManager(this.appId, this.configService, this.packetService, this.flowObjectiveService);
        this.icmpHandler = new IcmpHandler(this.configService, this.packetService);
        this.deviceListener = new InnerDeviceListener();
        this.routingService.addFibListener((FibListener)new InternalFibListener());
        this.routingService.start();
        this.deviceService.addListener(this.deviceListener);
        this.connectivityManager.start();
        this.icmpHandler.start();
        if (this.deviceService.isAvailable(this.deviceId)) {
            this.processIntfFilters(true, this.configService.getInterfaces());
        }
        if (this.deviceService.isAvailable(this.ctrlDeviceId)) {
            this.connectivityManager.notifySwitchAvailable();
        }
        log.info("BgpRouter started");
    }

    @Deactivate
    protected void deactivate() {
        this.routingService.stop();
        this.connectivityManager.stop();
        this.icmpHandler.stop();
        this.deviceService.removeListener(this.deviceListener);
        log.info("BgpRouter stopped");
    }

    private void getDeviceConfiguration(Map<String, BgpSpeaker> bgps) {
        if (bgps == null || bgps.values().isEmpty()) {
            log.error("BGP speakers configuration is missing");
            return;
        }
        Iterator<BgpSpeaker> iterator = bgps.values().iterator();
        if (iterator.hasNext()) {
            BgpSpeaker s = iterator.next();
            this.ctrlDeviceId = s.connectPoint().deviceId();
            if (s.interfaceAddresses() == null || s.interfaceAddresses().isEmpty()) {
                log.error("BGP Router must have interfaces configured");
                return;
            }
            this.deviceId = ((InterfaceAddress)s.interfaceAddresses().get(0)).connectPoint().deviceId();
        }
        log.info("Router dpid: {}", (Object)this.deviceId);
        log.info("Control Plane OVS dpid: {}", (Object)this.ctrlDeviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFibEntry(Collection<FibUpdate> updates) {
        HashMap<FibEntry, Integer> toInstall = new HashMap<FibEntry, Integer>(updates.size());
        for (FibUpdate update : updates) {
            Integer nextId;
            FibEntry entry = update.entry();
            this.addNextHop(entry);
            Multimap<NextHopGroupKey, FibEntry> multimap = this.pendingUpdates;
            synchronized (multimap) {
                nextId = this.nextHops.get(entry.nextHopIp());
            }
            toInstall.put(update.entry(), nextId);
        }
        this.installFlows(toInstall);
    }

    private void installFlows(Map<FibEntry, Integer> entriesToInstall) {
        for (Map.Entry<FibEntry, Integer> entry : entriesToInstall.entrySet()) {
            FibEntry fibEntry = entry.getKey();
            Integer nextId = entry.getValue();
            this.flowObjectiveService.forward(this.deviceId, this.generateRibForwardingObj(fibEntry.prefix(), nextId).add());
            log.trace("Sending forwarding objective {} -> nextId:{}", (Object)fibEntry, (Object)nextId);
        }
    }

    private synchronized void deleteFibEntry(Collection<FibUpdate> withdraws) {
        for (FibUpdate update : withdraws) {
            FibEntry entry = update.entry();
            this.flowObjectiveService.forward(this.deviceId, this.generateRibForwardingObj(entry.prefix(), null).remove());
        }
    }

    private ForwardingObjective.Builder generateRibForwardingObj(IpPrefix prefix, Integer nextId) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPDst(prefix).build();
        int priority = prefix.prefixLength() * 5 + 100;
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(selector).withPriority(priority).withFlag(ForwardingObjective.Flag.SPECIFIC);
        if (nextId == null) {
            fwdBuilder.withTreatment(DefaultTrafficTreatment.builder().build());
        } else {
            fwdBuilder.nextStep(nextId.intValue());
        }
        return fwdBuilder;
    }

    private synchronized void addNextHop(FibEntry entry) {
        this.prefixToNextHop.put(entry.prefix(), entry.nextHopIp());
        if (this.nextHopsCount.count((Object)entry.nextHopIp()) == 0) {
            Interface egressIntf = this.configService.getMatchingInterface(entry.nextHopIp());
            if (egressIntf == null) {
                log.warn("no egress interface found for {}", (Object)entry);
                return;
            }
            NextHopGroupKey groupKey = new NextHopGroupKey(entry.nextHopIp());
            NextHop nextHop = new NextHop(entry.nextHopIp(), entry.nextHopMac(), groupKey);
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setEthSrc(egressIntf.mac()).setEthDst(nextHop.mac()).pushVlan().setVlanId(egressIntf.vlan()).setVlanPcp(Byte.valueOf((byte)0)).setOutput(egressIntf.connectPoint().port()).build();
            int nextId = this.flowObjectiveService.allocateNextId();
            NextObjective nextObjective = DefaultNextObjective.builder().withId(nextId).addTreatment(treatment).withType(NextObjective.Type.SIMPLE).fromApp(this.appId).add();
            this.flowObjectiveService.next(this.deviceId, nextObjective);
            this.nextHops.put(nextHop.ip(), nextId);
        }
        this.nextHopsCount.add((Object)entry.nextHopIp());
    }

    private void processIntfFilters(boolean install, Set<Interface> intfs) {
        log.info("Processing {} router interfaces", (Object)intfs.size());
        for (final Interface intf : intfs) {
            if (!intf.connectPoint().deviceId().equals((Object)this.deviceId)) continue;
            DefaultFilteringObjective.Builder fob = DefaultFilteringObjective.builder();
            fob.withKey(Criteria.matchInPort((PortNumber)intf.connectPoint().port())).addCondition(Criteria.matchEthDst((MacAddress)intf.mac())).addCondition(Criteria.matchVlanId((VlanId)intf.vlan()));
            intf.ipAddresses().stream().forEach(arg_0 -> BgpRouter.lambda$processIntfFilters$0((FilteringObjective.Builder)fob, arg_0));
            fob.permit().fromApp(this.appId);
            this.flowObjectiveService.filter(this.deviceId, fob.add(new ObjectiveContext(){

                public void onSuccess(Objective objective) {
                    log.info("Successfully installed interface based filtering objectives for intf {}", (Object)intf);
                }

                public void onError(Objective objective, ObjectiveError error) {
                    log.error("Failed to install interface filters for intf {}: {}", (Object)intf, (Object)error);
                }
            }));
        }
    }

    private static /* synthetic */ void lambda$processIntfFilters$0(FilteringObjective.Builder builder, InterfaceIpAddress ipaddr) {
        builder.addCondition(Criteria.matchIPDst((IpPrefix)IpPrefix.valueOf((IpAddress)ipaddr.ipAddress(), (int)32)));
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindRoutingService(RoutingService routingService) {
        this.routingService = routingService;
    }

    protected void unbindRoutingService(RoutingService routingService) {
        if (this.routingService == routingService) {
            this.routingService = null;
        }
    }

    protected void bindConfigService(RoutingConfigurationService routingConfigurationService) {
        this.configService = routingConfigurationService;
    }

    protected void unbindConfigService(RoutingConfigurationService routingConfigurationService) {
        if (this.configService == routingConfigurationService) {
            this.configService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (!BgpRouter.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                    log.info("Device connected {}", (Object)((Device)event.subject()).id());
                    if (((Device)event.subject()).id().equals((Object)BgpRouter.this.deviceId)) {
                        BgpRouter.this.processIntfFilters(true, BgpRouter.this.configService.getInterfaces());
                    }
                    if (!((Device)event.subject()).id().equals((Object)BgpRouter.this.ctrlDeviceId)) break;
                    BgpRouter.this.connectivityManager.notifySwitchAvailable();
                    break;
                }
                case DEVICE_UPDATED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    break;
                }
                case DEVICE_SUSPENDED: {
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_UPDATED: {
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
            }
        }
    }

    private class InternalFibListener
    implements FibListener {
        private InternalFibListener() {
        }

        public void update(Collection<FibUpdate> updates, Collection<FibUpdate> withdraws) {
            BgpRouter.this.deleteFibEntry(withdraws);
            BgpRouter.this.updateFibEntry(updates);
        }
    }
}

