/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgprouter;

import java.nio.ByteBuffer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.routing.config.Interface;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpHandler {
    private static final Logger log = LoggerFactory.getLogger(IcmpHandler.class);
    private final PacketService packetService;
    private final RoutingConfigurationService configService;
    private final IcmpProcessor processor = new IcmpProcessor();

    public IcmpHandler(RoutingConfigurationService configService, PacketService packetService) {
        this.configService = configService;
        this.packetService = packetService;
    }

    public void start() {
        this.packetService.addProcessor((PacketProcessor)this.processor, 0x2AAAAAAE);
    }

    public void stop() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
    }

    private void processPacketIn(InboundPacket pkt) {
        boolean ipMatches = false;
        Ethernet ethernet = pkt.parsed();
        IPv4 ipv4 = (IPv4)ethernet.getPayload();
        ConnectPoint connectPoint = pkt.receivedFrom();
        IpAddress destIpAddress = IpAddress.valueOf((int)ipv4.getDestinationAddress());
        Interface targetInterface = this.configService.getMatchingInterface(destIpAddress);
        if (targetInterface == null) {
            log.trace("No matching interface for {}", (Object)destIpAddress);
            return;
        }
        for (InterfaceIpAddress interfaceIpAddress : targetInterface.ipAddresses()) {
            if (!interfaceIpAddress.ipAddress().equals((Object)destIpAddress)) continue;
            ipMatches = true;
            break;
        }
        if (((ICMP)ipv4.getPayload()).getIcmpType() == 8 && ipMatches) {
            this.sendICMPResponse(ethernet, connectPoint);
        }
    }

    private void sendICMPResponse(Ethernet icmpRequest, ConnectPoint outport) {
        Ethernet icmpReplyEth = new Ethernet();
        IPv4 icmpRequestIpv4 = (IPv4)icmpRequest.getPayload();
        IPv4 icmpReplyIpv4 = new IPv4();
        int destAddress = icmpRequestIpv4.getDestinationAddress();
        icmpReplyIpv4.setDestinationAddress(icmpRequestIpv4.getSourceAddress());
        icmpReplyIpv4.setSourceAddress(destAddress);
        icmpReplyIpv4.setTtl((byte)64);
        icmpReplyIpv4.setChecksum((short)0);
        ICMP icmpReply = (ICMP)icmpRequestIpv4.getPayload().clone();
        icmpReply.setIcmpType((byte)0);
        icmpReply.setIcmpCode((byte)0);
        icmpReply.setChecksum((short)0);
        icmpReplyIpv4.setPayload((IPacket)icmpReply);
        icmpReplyEth.setPayload((IPacket)icmpReplyIpv4);
        icmpReplyEth.setEtherType((short)2048);
        icmpReplyEth.setDestinationMACAddress(icmpRequest.getSourceMACAddress());
        icmpReplyEth.setSourceMACAddress(icmpRequest.getDestinationMACAddress());
        icmpReplyEth.setVlanID(icmpRequest.getVlanID());
        this.sendPacketOut(outport, icmpReplyEth);
    }

    private void sendPacketOut(ConnectPoint outport, Ethernet payload) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outport.port()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(outport.deviceId(), treatment, ByteBuffer.wrap(payload.serialize()));
        this.packetService.emit((OutboundPacket)packet);
    }

    private class IcmpProcessor
    implements PacketProcessor {
        private IcmpProcessor() {
        }

        public void process(PacketContext context) {
            IPv4 ipv4Packet;
            if (context.isHandled()) {
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            if (packet == null) {
                return;
            }
            if (packet.getEtherType() == 2048 && (ipv4Packet = (IPv4)packet.getPayload()).getProtocol() == 1) {
                IcmpHandler.this.processPacketIn(context.inPacket());
            }
        }
    }
}

