/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgprouter;

import java.util.Iterator;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TCP;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.routing.config.BgpPeer;
import org.onosproject.routing.config.BgpSpeaker;
import org.onosproject.routing.config.InterfaceAddress;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnellingConnectivityManager {
    private static final short BGP_PORT = 179;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationId appId;
    private final BgpSpeaker bgpSpeaker;
    private final PacketService packetService;
    private final RoutingConfigurationService configService;
    private final FlowObjectiveService flowObjectiveService;
    private final BgpProcessor processor = new BgpProcessor();

    public TunnellingConnectivityManager(ApplicationId appId, RoutingConfigurationService configService, PacketService packetService, FlowObjectiveService flowObjectiveService) {
        this.appId = appId;
        this.configService = configService;
        this.packetService = packetService;
        this.flowObjectiveService = flowObjectiveService;
        BgpSpeaker bgpSpeaker = null;
        Iterator iterator = configService.getBgpSpeakers().values().iterator();
        if (iterator.hasNext()) {
            BgpSpeaker speaker;
            bgpSpeaker = speaker = (BgpSpeaker)iterator.next();
        }
        if (bgpSpeaker == null) {
            throw new IllegalArgumentException("Must have at least one BGP speaker configured");
        }
        this.bgpSpeaker = bgpSpeaker;
    }

    public void start() {
        this.packetService.addProcessor((PacketProcessor)this.processor, 0x2AAAAAAD);
    }

    public void stop() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
    }

    public void notifySwitchAvailable() {
        TrafficSelector selectorDst = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPProtocol((byte)6).matchTcpDst((short)179).build();
        TrafficSelector selectorSrc = DefaultTrafficSelector.builder().matchEthType((short)2048).matchIPProtocol((byte)6).matchTcpSrc((short)179).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().punt().build();
        ForwardingObjective puntSrc = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(selectorSrc).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).add();
        this.flowObjectiveService.forward(this.bgpSpeaker.connectPoint().deviceId(), puntSrc);
        ForwardingObjective puntDst = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(selectorDst).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).add();
        this.flowObjectiveService.forward(this.bgpSpeaker.connectPoint().deviceId(), puntDst);
        this.log.info("Sent punt forwarding objective to {}", (Object)this.bgpSpeaker.connectPoint().deviceId());
    }

    private void forward(PacketContext context) {
        BgpPeer peer;
        ConnectPoint outputPort = null;
        IPv4 ipv4 = (IPv4)context.inPacket().parsed().getPayload();
        IpAddress dstAddress = IpAddress.valueOf((int)ipv4.getDestinationAddress());
        if (context.inPacket().receivedFrom().equals((Object)this.bgpSpeaker.connectPoint()) && (peer = (BgpPeer)this.configService.getBgpPeers().get(dstAddress)) != null) {
            outputPort = peer.connectPoint();
        }
        for (InterfaceAddress addr : this.bgpSpeaker.interfaceAddresses()) {
            if (!addr.ipAddress().equals((Object)dstAddress) || context.inPacket().receivedFrom().equals((Object)this.bgpSpeaker.connectPoint())) continue;
            outputPort = this.bgpSpeaker.connectPoint();
        }
        if (outputPort != null) {
            TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(outputPort.port()).build();
            DefaultOutboundPacket o = new DefaultOutboundPacket(outputPort.deviceId(), t, context.inPacket().unparsed());
            this.packetService.emit((OutboundPacket)o);
        }
    }

    private class BgpProcessor
    implements PacketProcessor {
        private BgpProcessor() {
        }

        public void process(PacketContext context) {
            TCP tcpPacket;
            IPv4 ipv4Packet;
            if (context.isHandled()) {
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            if (packet == null) {
                return;
            }
            if (packet.getEtherType() == 2048 && (ipv4Packet = (IPv4)packet.getPayload()).getProtocol() == 6 && ((tcpPacket = (TCP)ipv4Packet.getPayload()).getDestinationPort() == 179 || tcpPacket.getSourcePort() == 179)) {
                TunnellingConnectivityManager.this.forward(context);
            }
        }
    }
}

