/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.config.AddressConfiguration;
import org.onosproject.config.AddressEntry;
import org.onosproject.config.NetworkConfigService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.host.PortAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class NetworkConfigReader
implements NetworkConfigService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CONFIG_DIR = "../config";
    private static final String DEFAULT_CONFIG_FILE = "addresses.json";
    private String configFileName = "addresses.json";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostAdminService hostAdminService;

    @Activate
    protected void activate() {
        AddressConfiguration config = this.readNetworkConfig();
        if (config != null) {
            this.applyNetworkConfig(config);
        }
        this.log.info("Started network config reader");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    private AddressConfiguration readNetworkConfig() {
        File configFile = new File(CONFIG_DIR, this.configFileName);
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.log.info("Loading config: {}", (Object)configFile.getAbsolutePath());
            AddressConfiguration config = (AddressConfiguration)mapper.readValue(configFile, AddressConfiguration.class);
            return config;
        }
        catch (FileNotFoundException e) {
            this.log.warn("Configuration file not found: {}", (Object)this.configFileName);
        }
        catch (IOException e) {
            this.log.error("Error loading configuration", (Throwable)e);
        }
        return null;
    }

    private void applyNetworkConfig(AddressConfiguration config) {
        for (AddressEntry entry : config.getAddresses()) {
            ConnectPoint cp = new ConnectPoint((ElementId)DeviceId.deviceId((String)NetworkConfigReader.dpidToUri(entry.getDpid())), PortNumber.portNumber((long)entry.getPortNumber()));
            HashSet<InterfaceIpAddress> interfaceIpAddresses = new HashSet<InterfaceIpAddress>();
            for (String strIp : entry.getIpAddresses()) {
                try {
                    String[] splits = strIp.split("/");
                    if (splits.length != 2) {
                        throw new IllegalArgumentException("Invalid IP address and prefix length format");
                    }
                    IpPrefix subnet = IpPrefix.valueOf((String)strIp);
                    IpAddress addr = IpAddress.valueOf((String)splits[0]);
                    InterfaceIpAddress ia = new InterfaceIpAddress(addr, subnet);
                    interfaceIpAddresses.add(ia);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Bad format for IP address in config: {}", (Object)strIp);
                }
            }
            MacAddress macAddress = null;
            if (entry.getMacAddress() != null) {
                try {
                    macAddress = MacAddress.valueOf((String)entry.getMacAddress());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Bad format for MAC address in config: {}", (Object)entry.getMacAddress());
                }
            }
            VlanId vlan = null;
            if (entry.getVlan() == null) {
                vlan = VlanId.NONE;
            } else {
                try {
                    vlan = VlanId.vlanId((short)entry.getVlan());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Bad format for VLAN id in config: {}", (Object)entry.getVlan());
                    vlan = VlanId.NONE;
                }
            }
            PortAddresses addresses = new PortAddresses(cp, interfaceIpAddresses, macAddress, vlan);
            this.hostAdminService.bindAddressesToPort(addresses);
        }
    }

    private static String dpidToUri(String dpid) {
        return "of:" + dpid.replace(":", "");
    }

    protected void bindHostAdminService(HostAdminService hostAdminService) {
        this.hostAdminService = hostAdminService;
    }

    protected void unbindHostAdminService(HostAdminService hostAdminService) {
        if (this.hostAdminService == hostAdminService) {
            this.hostAdminService = null;
        }
    }
}

