/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.acl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import org.easymock.EasyMock;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.JerseyTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.rest.BaseResource;
import org.onosproject.acl.AclRule;
import org.onosproject.acl.AclService;
import org.onosproject.acl.AclStore;
import org.onosproject.acl.AclWebApplication;
import org.onosproject.core.IdGenerator;

public class AclWebResourceTest
extends JerseyTest {
    final AclService mockAclService = (AclService)EasyMock.createMock(AclService.class);
    final AclStore mockAclStore = (AclStore)EasyMock.createMock(AclStore.class);
    final List<AclRule> rules = new ArrayList<AclRule>();

    public AclWebResourceTest() {
        super((Application)ResourceConfig.forApplicationClass(AclWebApplication.class));
    }

    @Before
    public void setUpMock() {
        EasyMock.expect((Object)this.mockAclService.getAclRules()).andReturn(this.rules).anyTimes();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(AclService.class, (Object)this.mockAclService).add(AclStore.class, (Object)this.mockAclStore);
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
        MockIdGenerator idGenerator = new MockIdGenerator();
        AclRule.bindIdGenerator((IdGenerator)idGenerator);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mockAclService});
    }

    @Test
    @Ignore(value="FIXME: This needs to get reworked")
    public void addRule() throws IOException {
        WebTarget wt = this.target();
        EasyMock.replay((Object[])new Object[]{this.mockAclService});
        String json = "{\"ipProto\":\"TCP\",\"dstTpPort\":\"80\"}";
        String response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Failed! Either srcIp or dstIp must be assigned."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Malformed IPv4 prefix string: 10.0.0.1. Address must take form \"x.x.x.x/y\""));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.256/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid IP address string: 10.0.0.256"));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.01/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid IP address string: 10.0.01"));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/a\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Failed! For input string: \"a\""));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/33\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Invalid prefix length 33. The value must be in the interval [0, 32]"));
        json = "{\"ipProto\":\"ARP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"80\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ipProto must be assigned to TCP, UDP, or ICMP."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"a\",\"action\":\"DENY\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"dstTpPort must be assigned to a numerical value."));
        json = "{\"ipProto\":\"TCP\",\"srcIp\":\"10.0.0.1/32\",\"dstTpPort\":\"80\",\"action\":\"PERMIT\"}";
        response = (String)wt.request().post(Entity.json((Object)json), String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"action must be assigned to ALLOW or DENY."));
    }

    private class MockIdGenerator
    implements IdGenerator {
        private AtomicLong nextId = new AtomicLong(0L);

        private MockIdGenerator() {
        }

        public long getNewId() {
            return this.nextId.getAndIncrement();
        }
    }
}

