/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.onlab.packet.Ip4Address;

public final class OpenstackExternalGateway {
    private final String networkId;
    private final boolean enablePnat;
    private final Map<String, Ip4Address> externalFixedIps;

    private OpenstackExternalGateway(String networkId, boolean enablePnat, Map<String, Ip4Address> externalFixedIps) {
        this.networkId = networkId;
        this.enablePnat = enablePnat;
        this.externalFixedIps = externalFixedIps;
    }

    public String networkId() {
        return this.networkId;
    }

    public boolean isEnablePnat() {
        return this.enablePnat;
    }

    public Map<String, Ip4Address> externalFixedIps() {
        return ImmutableMap.copyOf(this.externalFixedIps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OpenstackExternalGateway) {
            OpenstackExternalGateway that = (OpenstackExternalGateway)o;
            return this.networkId.equals(that.networkId) && this.enablePnat == that.enablePnat && this.externalFixedIps.equals(that.externalFixedIps);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.networkId, this.enablePnat, this.externalFixedIps);
    }

    public static final class Builder {
        private String networkId;
        private boolean enablePnat;
        private Map<String, Ip4Address> externalFixedIps = Maps.newHashMap();

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder enablePnat(boolean enablePnat) {
            this.enablePnat = enablePnat;
            return this;
        }

        public Builder externalFixedIps(Map<String, Ip4Address> externalFixedIps) {
            this.externalFixedIps.putAll(externalFixedIps);
            return this;
        }

        public OpenstackExternalGateway build() {
            return new OpenstackExternalGateway(this.networkId, this.enablePnat, (Map)ImmutableMap.copyOf(this.externalFixedIps));
        }
    }
}

