/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;

public final class OpenstackFloatingIP {
    private final String tenantId;
    private final String networkId;
    private final Ip4Address fixedIpAddress;
    private String portId;
    private String routerId;
    private final String id;
    private final Ip4Address floatingIpAddress;
    private final FloatingIpStatus status;

    private OpenstackFloatingIP(FloatingIpStatus status, String id, String tenantId, String networkId, Ip4Address fixedIpAddress, String portId, String routerId, Ip4Address floatingIpAddress) {
        this.status = status;
        this.id = id;
        this.tenantId = tenantId;
        this.networkId = networkId;
        this.fixedIpAddress = fixedIpAddress;
        this.portId = portId;
        this.routerId = routerId;
        this.floatingIpAddress = floatingIpAddress;
    }

    public FloatingIpStatus status() {
        return this.status;
    }

    public String id() {
        return this.id;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String networkId() {
        return this.networkId;
    }

    public Ip4Address fixedIpAddress() {
        return this.fixedIpAddress;
    }

    public String portId() {
        return this.portId;
    }

    public void updatePortId(String portId) {
        this.portId = portId;
    }

    public String routerId() {
        return this.routerId;
    }

    public void updateRouterId(String routerId) {
        this.routerId = routerId;
    }

    public Ip4Address floatingIpAddress() {
        return this.floatingIpAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OpenstackFloatingIP) {
            OpenstackFloatingIP that = (OpenstackFloatingIP)o;
            return this.status.equals((Object)that.status) && this.id.equals(that.id) && this.tenantId.equals(that.tenantId) && this.networkId.equals(that.networkId) && this.fixedIpAddress.equals((Object)that.fixedIpAddress) && this.floatingIpAddress.equals((Object)that.floatingIpAddress) && this.portId.equals(that.portId) && this.routerId.equals(that.routerId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.id, this.tenantId, this.networkId, this.floatingIpAddress, this.fixedIpAddress, this.portId, this.routerId});
    }

    public static final class Builder {
        private String tenantId;
        private String networkId;
        private Ip4Address fixedIpAddress;
        private String portId;
        private String routerId;
        private String id;
        private Ip4Address floatingIpAddress;
        private FloatingIpStatus status;

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder status(FloatingIpStatus status) {
            this.status = status;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder fixedIpAddress(Ip4Address fixedIpAddress) {
            this.fixedIpAddress = fixedIpAddress;
            return this;
        }

        public Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public Builder routerId(String routerId) {
            this.routerId = routerId;
            return this;
        }

        public Builder floatingIpAddress(Ip4Address floatingIpAddress) {
            this.floatingIpAddress = floatingIpAddress;
            return this;
        }

        public OpenstackFloatingIP build() {
            return new OpenstackFloatingIP((FloatingIpStatus)((Object)Preconditions.checkNotNull((Object)((Object)this.status))), (String)Preconditions.checkNotNull((Object)this.id), (String)Preconditions.checkNotNull((Object)this.tenantId), (String)Preconditions.checkNotNull((Object)this.networkId), this.fixedIpAddress, this.portId, this.routerId, (Ip4Address)Preconditions.checkNotNull((Object)this.floatingIpAddress));
        }
    }

    public static enum FloatingIpStatus {
        UP,
        DOWN,
        ACTIVE;

    }
}

