/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.onosproject.openstackinterface.OpenstackSubnet;

public final class OpenstackNetwork {
    private String name;
    private String tenantId;
    private String segmentId;
    private String id;
    private NetworkType networkType;
    private Collection<OpenstackSubnet> subnets;

    public static Builder builder() {
        return new Builder();
    }

    private OpenstackNetwork(String name, String tenantId, String id, String sid, NetworkType type, Collection<OpenstackSubnet> subnets) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId);
        this.segmentId = (String)Preconditions.checkNotNull((Object)sid);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.networkType = type;
        this.subnets = subnets;
    }

    public String name() {
        return this.name;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String id() {
        return this.id;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public NetworkType networkType() {
        return this.networkType;
    }

    public Collection<OpenstackSubnet> subnets() {
        return this.subnets;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static final class Builder {
        private String name;
        private String tenantId;
        private String id;
        private String sid;
        private NetworkType networkType;
        private Collection<OpenstackSubnet> subnets;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder segmentId(String sid) {
            this.sid = sid;
            return this;
        }

        public Builder networkType(NetworkType type) {
            this.networkType = type;
            return this;
        }

        public Builder subnets(Collection<OpenstackSubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        public OpenstackNetwork build() {
            return new OpenstackNetwork(this.name, this.tenantId, this.id, this.sid, this.networkType, this.subnets);
        }
    }

    public static enum NetworkType {
        VXLAN;

    }
}

