/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;

public final class OpenstackPort {
    private PortStatus status;
    private String name;
    private ImmutableMap<IpAddress, MacAddress> allowedAddressPairs;
    private boolean adminStateUp;
    private String networkId;
    private String tenantId;
    private String deviceOwner;
    private MacAddress macAddress;
    private ImmutableMap<String, Ip4Address> fixedIps;
    private String id;
    private Collection<String> securityGroups;
    private String deviceId;

    private OpenstackPort(PortStatus status, String name, Map<IpAddress, MacAddress> allowedAddressPairs, boolean adminStateUp, String networkId, String tenantId, String deviceOwner, MacAddress macAddress, Map<String, Ip4Address> fixedIps, String id, Collection<String> securityGroups, String deviceId) {
        this.status = status;
        this.name = name;
        this.allowedAddressPairs = (ImmutableMap)Preconditions.checkNotNull((Object)ImmutableMap.copyOf(allowedAddressPairs));
        this.adminStateUp = adminStateUp;
        this.networkId = (String)Preconditions.checkNotNull((Object)networkId);
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId);
        this.deviceOwner = deviceOwner;
        this.macAddress = (MacAddress)Preconditions.checkNotNull((Object)macAddress);
        this.fixedIps = (ImmutableMap)Preconditions.checkNotNull((Object)ImmutableMap.copyOf(fixedIps));
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.securityGroups = securityGroups;
        this.deviceId = deviceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public PortStatus status() {
        return this.status;
    }

    public String name() {
        return this.name;
    }

    public Map<IpAddress, MacAddress> allowedAddressPairs() {
        return this.allowedAddressPairs;
    }

    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public String networkId() {
        return this.networkId;
    }

    public String deviceOwner() {
        return this.deviceOwner;
    }

    public MacAddress macAddress() {
        return this.macAddress;
    }

    public Map<String, Ip4Address> fixedIps() {
        return this.fixedIps;
    }

    public String id() {
        return this.id;
    }

    public Collection<String> securityGroups() {
        return this.securityGroups;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public static final class Builder {
        private PortStatus status;
        private String name;
        private Map<IpAddress, MacAddress> allowedAddressPairs;
        private boolean adminStateUp;
        private String networkId;
        private String tenantId;
        private String deviceOwner;
        private MacAddress macAddress;
        private Map<String, Ip4Address> fixedIps = Maps.newHashMap();
        private String id;
        private Collection<String> securityGroups;
        private String deviceId;

        Builder() {
            this.allowedAddressPairs = Maps.newHashMap();
        }

        public Builder portStatus(PortStatus status) {
            this.status = status;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder allowedAddressPairs(Map<IpAddress, MacAddress> addrPairs) {
            this.allowedAddressPairs.putAll(addrPairs);
            return this;
        }

        public Builder adminState(boolean isAdminStateUp) {
            this.adminStateUp = isAdminStateUp;
            return this;
        }

        public Builder netwrokId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder deviceOwner(String owner) {
            this.deviceOwner = owner;
            return this;
        }

        public Builder macAddress(MacAddress mac) {
            this.macAddress = mac;
            return this;
        }

        public Builder fixedIps(Map<String, Ip4Address> fixedIpList) {
            this.fixedIps.putAll(fixedIpList);
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder securityGroup(Collection<String> securityGroupList) {
            this.securityGroups = securityGroupList;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public OpenstackPort build() {
            return new OpenstackPort(this.status, this.name, this.allowedAddressPairs, this.adminStateUp, this.networkId, this.networkId, this.deviceOwner, this.macAddress, this.fixedIps, this.id, this.securityGroups, this.deviceId);
        }
    }

    public static enum PortStatus {
        UP,
        DOWN,
        ACTIVE,
        NA;

    }
}

