/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.openstackinterface.OpenstackExternalGateway;

public final class OpenstackRouter {
    private final String tenantId;
    private final String id;
    private final String name;
    private RouterStatus status;
    private boolean adminStateUp;
    private OpenstackExternalGateway gatewayExternalInfo;

    private OpenstackRouter(String id, String tenantId, String name, RouterStatus status, boolean adminStateUp, OpenstackExternalGateway gatewayExternalInfo) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.status = status;
        this.adminStateUp = adminStateUp;
        this.gatewayExternalInfo = gatewayExternalInfo;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public RouterStatus status() {
        return this.status;
    }

    public boolean adminStateUp() {
        return this.adminStateUp;
    }

    public OpenstackExternalGateway gatewayExternalInfo() {
        return this.gatewayExternalInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OpenstackRouter) {
            OpenstackRouter that = (OpenstackRouter)o;
            return this.adminStateUp == that.adminStateUp && this.gatewayExternalInfo.equals(that.gatewayExternalInfo) && this.id.equals(that.id) && this.name.equals(that.name) && this.status.equals((Object)that.status) && this.tenantId.equals(that.tenantId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.adminStateUp, this.gatewayExternalInfo, this.id, this.name, this.status, this.tenantId});
    }

    public static final class Builder {
        private String tenantId;
        private String id;
        private String name;
        private RouterStatus status;
        private Boolean adminStateUp;
        private OpenstackExternalGateway gatewayExternalInfo;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder status(RouterStatus status) {
            this.status = status;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder adminStateUp(boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this;
        }

        public Builder gatewayExternalInfo(OpenstackExternalGateway gatewayExternalInfo) {
            this.gatewayExternalInfo = gatewayExternalInfo;
            return this;
        }

        public OpenstackRouter build() {
            return new OpenstackRouter((String)Preconditions.checkNotNull((Object)this.id), (String)Preconditions.checkNotNull((Object)this.tenantId), this.name, (RouterStatus)((Object)Preconditions.checkNotNull((Object)((Object)this.status))), (Boolean)Preconditions.checkNotNull((Object)this.adminStateUp), this.gatewayExternalInfo);
        }
    }

    public static enum RouterStatus {
        UP,
        DOWN,
        ACTIVE;

    }
}

