/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class OpenstackRouterInterface {
    private final String id;
    private final String tenantId;
    private final String subnetId;
    private final String portId;

    private OpenstackRouterInterface(String id, String tenantId, String subnetId, String portId) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId);
        this.subnetId = (String)Preconditions.checkNotNull((Object)subnetId);
        this.portId = (String)Preconditions.checkNotNull((Object)portId);
    }

    public String id() {
        return this.id;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String portId() {
        return this.portId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OpenstackRouterInterface) {
            OpenstackRouterInterface that = (OpenstackRouterInterface)o;
            return this.id.equals(that.id) && this.portId.equals(that.portId) && this.subnetId.equals(that.subnetId) && this.tenantId.equals(that.tenantId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.portId, this.subnetId, this.tenantId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String tenantId;
        private String subnetId;
        private String portId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public OpenstackRouterInterface build() {
            return new OpenstackRouterInterface((String)Preconditions.checkNotNull((Object)this.id), (String)Preconditions.checkNotNull((Object)this.tenantId), (String)Preconditions.checkNotNull((Object)this.subnetId), (String)Preconditions.checkNotNull((Object)this.portId));
        }
    }
}

