/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.onosproject.openstackinterface.OpenstackSecurityGroupRule;

public final class OpenstackSecurityGroup {
    private String description;
    private String id;
    private String name;
    private Collection<OpenstackSecurityGroupRule> rules;
    private String tenantId;

    private OpenstackSecurityGroup(String description, String id, String name, Collection<OpenstackSecurityGroupRule> rules, String tenantId) {
        this.description = description;
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.rules = rules;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Collection<OpenstackSecurityGroupRule> rules() {
        return Collections.unmodifiableCollection(this.rules);
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder("Security Group :").append(this.description + ",").append(this.id + ",").append(this.name + ",");
        this.rules.forEach(rule -> sbuilder.append(rule.toString()));
        sbuilder.append(this.tenantId);
        return sbuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OpenstackSecurityGroup) {
            OpenstackSecurityGroup that = (OpenstackSecurityGroup)o;
            return this.description.equals(that.description) && this.tenantId.equals(that.tenantId) && this.id.equals(that.id) && this.name.equals(that.name) && this.rules.containsAll(that.rules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.tenantId, this.id, this.name, this.rules);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String id;
        private String name;
        private Collection<OpenstackSecurityGroupRule> rules;
        private String tenantId;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder rules(Collection<OpenstackSecurityGroupRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OpenstackSecurityGroup build() {
            return new OpenstackSecurityGroup(this.description, this.id, this.name, this.rules, this.tenantId);
        }
    }
}

