/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpPrefix;

public final class OpenstackSecurityGroupRule {
    private final Direction direction;
    private final String ethertype;
    private final String id;
    private final int portRangeMax;
    private final int portRangeMin;
    private final String protocol;
    private final String remoteGroupId;
    private final IpPrefix remoteIpPrefix;
    private final String secuityGroupId;
    private final String tenantId;

    private OpenstackSecurityGroupRule(Direction direction, String ethertype, String id, int portRangeMax, int portRangeMin, String protocol, String remoteGroupId, IpPrefix remoteIpPrefix, String securityGroupId, String tenantId) {
        this.direction = direction;
        this.ethertype = ethertype;
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.portRangeMax = portRangeMax;
        this.portRangeMin = portRangeMin;
        this.protocol = protocol;
        this.remoteGroupId = remoteGroupId;
        this.remoteIpPrefix = remoteIpPrefix;
        this.secuityGroupId = securityGroupId;
        this.tenantId = tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Direction direction() {
        return this.direction;
    }

    public String ethertype() {
        return this.ethertype;
    }

    public String id() {
        return this.id;
    }

    public int portRangeMax() {
        return this.portRangeMax;
    }

    public int portRangeMin() {
        return this.portRangeMin;
    }

    public String protocol() {
        return this.protocol;
    }

    public String remoteGroupId() {
        return this.remoteGroupId;
    }

    public IpPrefix remoteIpPrefix() {
        return this.remoteIpPrefix;
    }

    public String secuityGroupId() {
        return this.secuityGroupId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String toString() {
        return " [" + ((Object)((Object)this.direction) + ",") + (this.ethertype + ",") + (this.id + ",") + (this.portRangeMax + ",") + (this.portRangeMin + ",") + (this.protocol + ",'") + (this.remoteGroupId + ",") + (this.remoteIpPrefix + ",") + (this.secuityGroupId + ",") + (this.tenantId + "] ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this instanceof OpenstackSecurityGroupRule) {
            OpenstackSecurityGroupRule that = (OpenstackSecurityGroupRule)o;
            return this.direction.equals((Object)that.direction) && this.ethertype.equals(that.ethertype) && this.id.equals(that.id) && this.portRangeMax == that.portRangeMax && this.portRangeMin == that.portRangeMin && this.protocol.equals(that.protocol) && this.remoteGroupId.equals(that.remoteGroupId) && this.secuityGroupId.equals(that.secuityGroupId) && this.remoteIpPrefix.equals((Object)that.remoteIpPrefix) && this.tenantId.equals(that.tenantId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.ethertype, this.id, this.portRangeMax, this.portRangeMin, this.protocol, this.remoteGroupId, this.remoteIpPrefix, this.secuityGroupId, this.tenantId});
    }

    public static final class Builder {
        private String direction;
        private String etherType;
        private String id;
        private String portRangeMax;
        private String portRangeMin;
        private String protocol;
        private String remoteGroupId;
        private String remoteIpPrefix;
        private String secuityGroupId;
        private String tenantId;

        public Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Builder etherType(String etherType) {
            this.etherType = etherType;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder portRangeMax(String portRangeMax) {
            this.portRangeMax = portRangeMax;
            return this;
        }

        public Builder portRangeMin(String portRangeMin) {
            this.portRangeMin = portRangeMin;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder remoteGroupId(String remoteGroupId) {
            this.remoteGroupId = remoteGroupId;
            return this;
        }

        public Builder remoteIpPrefix(String remoteIpPrefix) {
            this.remoteIpPrefix = remoteIpPrefix;
            return this;
        }

        public Builder securityGroupId(String securityGroupId) {
            this.secuityGroupId = securityGroupId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public OpenstackSecurityGroupRule build() {
            int portRangeMinInt = this.portRangeMin == null || this.portRangeMin.equals("null") ? -1 : Integer.parseInt(this.portRangeMin);
            int portRangeMaxInt = this.portRangeMax == null || this.portRangeMax.equals("null") ? -1 : Integer.parseInt(this.portRangeMax);
            IpPrefix ipPrefix = this.remoteIpPrefix == null || this.remoteIpPrefix.equals("null") ? null : IpPrefix.valueOf((String)this.remoteIpPrefix);
            return new OpenstackSecurityGroupRule(Direction.valueOf(this.direction.toUpperCase()), this.etherType, this.id, portRangeMaxInt, portRangeMinInt, this.protocol, this.remoteGroupId, ipPrefix, this.secuityGroupId, this.tenantId);
        }
    }

    public static enum Direction {
        INGRESS,
        EGRESS;

    }
}

