/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.onlab.packet.Ip4Address;

public final class OpenstackSubnet {
    private String name;
    private boolean enableHhcp;
    private String networkId;
    private String tenantId;
    private List<Ip4Address> dnsNameservers;
    private String gatewayIp;
    private String cidr;
    private String id;
    private Collection<String> securityGroups;

    private OpenstackSubnet(String name, boolean enableHhcp, String networkId, String tenantId, List<Ip4Address> dnsNameservers, String gatewayIp, String cidr, String id, Collection<String> securityGroups) {
        this.name = name;
        this.enableHhcp = enableHhcp;
        this.networkId = (String)Preconditions.checkNotNull((Object)networkId);
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId);
        this.dnsNameservers = dnsNameservers;
        this.gatewayIp = gatewayIp;
        this.cidr = (String)Preconditions.checkNotNull((Object)cidr);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.securityGroups = securityGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public boolean enableHhcp() {
        return this.enableHhcp;
    }

    public String networkId() {
        return this.networkId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public List<Ip4Address> dnsNameservers() {
        return this.dnsNameservers;
    }

    public String gatewayIp() {
        return this.gatewayIp;
    }

    public String cidr() {
        return this.cidr;
    }

    public String id() {
        return this.id;
    }

    public Collection<String> securityGroups() {
        return Collections.unmodifiableCollection(this.securityGroups);
    }

    public static final class Builder {
        private String name;
        private boolean enableDhcp;
        private String networkId;
        private String tenantId;
        private List<Ip4Address> dnsNameservers;
        private String gatewayIp;
        private String cidr;
        private String id;
        private Collection<String> securityGroups;

        Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEnableDhcp(boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return this;
        }

        public Builder setNetworkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setDnsNameservers(List<Ip4Address> dnsNameservers) {
            this.dnsNameservers = dnsNameservers;
            return this;
        }

        public Builder setGatewayIp(String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return this;
        }

        public Builder setCidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public OpenstackSubnet build() {
            return new OpenstackSubnet(this.name, this.enableDhcp, this.networkId, this.tenantId, this.dnsNameservers, this.gatewayIp, this.cidr, this.id, this.securityGroups);
        }
    }
}

