/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.routing.config.RoutersConfig;

public class RouterInfo {
    private final ConnectPoint controlPlaneConnectPoint;
    private final boolean ospfEnabled;
    private final Set<String> interfaces;

    public RouterInfo(ConnectPoint controlPlaneConnectPoint, boolean ospfEnabled, Set<String> interfaces) {
        this.controlPlaneConnectPoint = (ConnectPoint)Preconditions.checkNotNull((Object)controlPlaneConnectPoint);
        this.ospfEnabled = ospfEnabled;
        this.interfaces = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(interfaces)));
    }

    public ConnectPoint controlPlaneConnectPoint() {
        return this.controlPlaneConnectPoint;
    }

    public DeviceId deviceId() {
        return this.controlPlaneConnectPoint.deviceId();
    }

    public boolean ospfEnabled() {
        return this.ospfEnabled;
    }

    public Set<String> interfaces() {
        return this.interfaces;
    }

    public static RouterInfo from(RoutersConfig.Router config) {
        return new RouterInfo(config.controlPlaneConnectPoint(), config.isOspfEnabled(), config.interfaces());
    }
}

