/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class BgpConfig
extends Config<ApplicationId> {
    public static final String SPEAKERS = "bgpSpeakers";
    public static final String CONNECT_POINT = "connectPoint";
    public static final String NAME = "name";
    public static final String PEERS = "peers";
    public static final String VLAN = "vlan";

    public Set<BgpSpeakerConfig> bgpSpeakers() {
        HashSet speakers = Sets.newHashSet();
        JsonNode speakersNode = this.object.get(SPEAKERS);
        if (speakersNode == null) {
            return speakers;
        }
        speakersNode.forEach(jsonNode -> {
            HashSet listenAddresses = Sets.newHashSet();
            jsonNode.path(PEERS).forEach(addressNode -> listenAddresses.add(IpAddress.valueOf((String)addressNode.asText())));
            Optional<Object> name = jsonNode.get(NAME) == null ? Optional.empty() : Optional.of(jsonNode.get(NAME).asText());
            VlanId vlan = this.getVlan((JsonNode)jsonNode);
            speakers.add(new BgpSpeakerConfig(name, vlan, ConnectPoint.deviceConnectPoint((String)jsonNode.path(CONNECT_POINT).asText()), listenAddresses));
        });
        return speakers;
    }

    private VlanId getVlan(JsonNode node) {
        VlanId vlan = VlanId.NONE;
        if (!node.path(VLAN).isMissingNode()) {
            vlan = VlanId.vlanId((String)node.path(VLAN).asText());
        }
        return vlan;
    }

    public BgpSpeakerConfig getSpeakerWithName(String name) {
        for (BgpSpeakerConfig speaker : this.bgpSpeakers()) {
            if (!speaker.name().filter(name::equals).isPresent()) continue;
            return speaker;
        }
        return null;
    }

    public void addSpeaker(BgpSpeakerConfig speaker) {
        ObjectNode speakerNode = JsonNodeFactory.instance.objectNode();
        speakerNode.put(NAME, speaker.name().get());
        speakerNode.put(VLAN, speaker.vlan().toString());
        speakerNode.put(CONNECT_POINT, speaker.connectPoint().elementId().toString() + "/" + speaker.connectPoint().port().toString());
        ArrayNode peersNode = speakerNode.putArray(PEERS);
        for (IpAddress peerAddress : speaker.peers()) {
            peersNode.add(peerAddress.toString());
        }
        ArrayNode speakersArray = this.bgpSpeakers().isEmpty() ? this.initBgpSpeakersConfiguration() : (ArrayNode)this.object.get(SPEAKERS);
        speakersArray.add((JsonNode)speakerNode);
    }

    public void removeSpeaker(String speakerName) {
        ArrayNode speakersArray = (ArrayNode)this.object.get(SPEAKERS);
        for (int i = 0; i < speakersArray.size(); ++i) {
            if (!speakersArray.get(i).hasNonNull(NAME) || !speakersArray.get(i).get(NAME).asText().equals(speakerName)) continue;
            speakersArray.remove(i);
            return;
        }
    }

    public void addPeerToSpeaker(String speakerName, IpAddress peerAddress) {
        JsonNode speakersNode = this.object.get(SPEAKERS);
        speakersNode.forEach(jsonNode -> {
            if (jsonNode.hasNonNull(NAME) && jsonNode.get(NAME).asText().equals(speakerName)) {
                ArrayNode peersNode = (ArrayNode)jsonNode.get(PEERS);
                for (int i = 0; i < peersNode.size(); ++i) {
                    if (!peersNode.get(i).asText().equals(peerAddress.toString())) continue;
                    return;
                }
                peersNode.add(peerAddress.toString());
            }
        });
    }

    public BgpSpeakerConfig getSpeakerFromPeer(IpAddress peerAddress) {
        for (BgpSpeakerConfig speaker : this.bgpSpeakers()) {
            if (!speaker.peers().contains(peerAddress)) continue;
            return speaker;
        }
        return null;
    }

    public void removePeerFromSpeaker(BgpSpeakerConfig speaker, IpAddress peerAddress) {
        JsonNode speakersNode = this.object.get(SPEAKERS);
        speakersNode.forEach(jsonNode -> {
            if (jsonNode.hasNonNull(NAME) && jsonNode.get(NAME).asText().equals(speaker.name().get())) {
                ArrayNode peersNode = (ArrayNode)jsonNode.get(PEERS);
                for (int i = 0; i < peersNode.size(); ++i) {
                    if (!peersNode.get(i).asText().equals(peerAddress.toString())) continue;
                    peersNode.remove(i);
                    return;
                }
            }
        });
    }

    private ArrayNode initBgpSpeakersConfiguration() {
        return this.object.putArray(SPEAKERS);
    }

    public static class BgpSpeakerConfig {
        private Optional<String> name;
        private VlanId vlanId;
        private ConnectPoint connectPoint;
        private Set<IpAddress> peers;

        public BgpSpeakerConfig(Optional<String> name, VlanId vlanId, ConnectPoint connectPoint, Set<IpAddress> peers) {
            this.name = (Optional)Preconditions.checkNotNull(name);
            this.vlanId = (VlanId)Preconditions.checkNotNull((Object)vlanId);
            this.connectPoint = (ConnectPoint)Preconditions.checkNotNull((Object)connectPoint);
            this.peers = (Set)Preconditions.checkNotNull(peers);
        }

        public Optional<String> name() {
            return this.name;
        }

        public VlanId vlan() {
            return this.vlanId;
        }

        public ConnectPoint connectPoint() {
            return this.connectPoint;
        }

        public Set<IpAddress> peers() {
            return this.peers;
        }

        public boolean isConnectedToPeer(IpAddress peer) {
            for (IpAddress entry : this.peers()) {
                if (!entry.equals((Object)peer)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BgpSpeakerConfig) {
                BgpSpeakerConfig that = (BgpSpeakerConfig)obj;
                return Objects.equals(this.name, that.name) && Objects.equals(this.vlanId, that.vlanId) && Objects.equals(this.connectPoint, that.connectPoint) && Objects.equals(this.peers, that.peers);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.vlanId, this.connectPoint, this.peers);
        }
    }
}

