/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class RoutersConfig
extends Config<ApplicationId> {
    private static final String CP_CONNECT_POINT = "controlPlaneConnectPoint";
    private static final String OSPF_ENABLED = "ospfEnabled";
    private static final String PIM_ENABLED = "pimEnabled";
    private static final String INTERFACES = "interfaces";

    public Set<Router> getRouters() {
        HashSet<Router> routers = new HashSet<Router>();
        for (JsonNode routerNode : this.array) {
            ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)routerNode.path(CP_CONNECT_POINT).asText());
            boolean ospfEnabled = routerNode.path(OSPF_ENABLED).asBoolean();
            JsonNode intfNode = routerNode.path(INTERFACES);
            HashSet<String> interfaces = new HashSet<String>(this.array.size());
            if (!intfNode.isMissingNode()) {
                ArrayNode array = (ArrayNode)intfNode;
                for (JsonNode intf : array) {
                    interfaces.add(intf.asText());
                }
            }
            routers.add(new Router(connectPoint, ospfEnabled, interfaces));
        }
        return ImmutableSet.copyOf(routers);
    }

    public boolean isValid() {
        for (JsonNode node : this.array) {
            ObjectNode routerNode = (ObjectNode)node;
            if (!this.hasOnlyFields(routerNode, new String[]{INTERFACES, CP_CONNECT_POINT, OSPF_ENABLED, PIM_ENABLED})) {
                return false;
            }
            JsonNode intfNode = routerNode.path(INTERFACES);
            if (!intfNode.isMissingNode() && !intfNode.isArray()) {
                return false;
            }
            boolean valid = this.isConnectPoint(routerNode, CP_CONNECT_POINT, Config.FieldPresence.MANDATORY) && this.isBoolean(routerNode, OSPF_ENABLED, Config.FieldPresence.OPTIONAL) && this.isBoolean(routerNode, PIM_ENABLED, Config.FieldPresence.OPTIONAL);
            if (valid) continue;
            return false;
        }
        return true;
    }

    public static class Router {
        private final ConnectPoint connectPoint;
        private final boolean ospfEnabled;
        private final Set<String> interfaces;

        Router(ConnectPoint controlPlaneConnectPoint, boolean ospfEnabled, Set<String> interfaces) {
            this.connectPoint = controlPlaneConnectPoint;
            this.ospfEnabled = ospfEnabled;
            this.interfaces = interfaces;
        }

        public ConnectPoint controlPlaneConnectPoint() {
            return this.connectPoint;
        }

        public boolean isOspfEnabled() {
            return this.ospfEnabled;
        }

        public Set<String> interfaces() {
            return this.interfaces;
        }
    }
}

