/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.BgpConfig;
import org.onosproject.routing.config.RouterConfig;
import org.onosproject.routing.config.RoutersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoutingConfiguration {
    private static final String WARNING = "Config apps/org.onosproject.routing/router is deprecated and will be removed in a future release.";
    private static final String WARNING2 = "Use apps/org.onosproject.routing/routers instead";
    private static final Logger log = LoggerFactory.getLogger(RoutingConfiguration.class);
    private static ConfigFactory<ApplicationId, BgpConfig> bgpConfigFactory = new ConfigFactory<ApplicationId, BgpConfig>(SubjectFactories.APP_SUBJECT_FACTORY, BgpConfig.class, "bgp"){

        public BgpConfig createConfig() {
            return new BgpConfig();
        }
    };
    private static ConfigFactory<ApplicationId, RouterConfig> routerConfigFactory = new ConfigFactory<ApplicationId, RouterConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RouterConfig.class, "router"){

        public RouterConfig createConfig() {
            return new RouterConfig();
        }
    };
    private static ConfigFactory<ApplicationId, RoutersConfig> routersConfigFactory = new ConfigFactory<ApplicationId, RoutersConfig>(SubjectFactories.APP_SUBJECT_FACTORY, RoutersConfig.class, "routers", true){

        public RoutersConfig createConfig() {
            return new RoutersConfig();
        }
    };
    private static ImmutableList<ConfigFactory<?, ?>> factories = ImmutableList.builder().add(bgpConfigFactory).add(routerConfigFactory).add(routersConfigFactory).build();
    private static Integer registrations = 0;
    private static final Object REGISTRATIONS_LOCK = new Object();

    private RoutingConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(NetworkConfigRegistry registry) {
        Object object = REGISTRATIONS_LOCK;
        synchronized (object) {
            if (registrations == 0) {
                factories.forEach(arg_0 -> ((NetworkConfigRegistry)registry).registerConfigFactory(arg_0));
            }
            Integer n = registrations;
            Integer n2 = registrations = Integer.valueOf(registrations + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(NetworkConfigRegistry registry) {
        Object object = REGISTRATIONS_LOCK;
        synchronized (object) {
            Integer n = registrations;
            Integer n2 = registrations = Integer.valueOf(registrations - 1);
            if (registrations == 0) {
                factories.forEach(arg_0 -> ((NetworkConfigRegistry)registry).unregisterConfigFactory(arg_0));
            }
        }
    }

    public static Set<RoutersConfig.Router> getRouterConfigurations(NetworkConfigService configService, ApplicationId routingAppId) {
        RouterConfig config = (RouterConfig)configService.getConfig((Object)routingAppId, RoutingService.ROUTER_CONFIG_CLASS);
        RoutersConfig multiConfig = (RoutersConfig)configService.getConfig((Object)routingAppId, RoutersConfig.class);
        if (config != null) {
            log.warn(WARNING);
            log.warn(WARNING2);
            return Collections.singleton(new RoutersConfig.Router(config.getControlPlaneConnectPoint(), config.getOspfEnabled(), Sets.newHashSet(config.getInterfaces())));
        }
        if (multiConfig != null) {
            return multiConfig.getRouters();
        }
        return Collections.emptySet();
    }
}

