/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.routing.config.BgpConfig;

public class BgpConfigTest {
    private static final ApplicationId APP_ID = new TestApplicationId("org.onosproject.router");
    private static final IpAddress IP1 = IpAddress.valueOf((String)"10.0.1.1");
    private static final IpAddress IP2 = IpAddress.valueOf((String)"10.0.2.1");
    private static final IpAddress IP3 = IpAddress.valueOf((String)"10.0.3.1");
    private static final IpAddress IP4 = IpAddress.valueOf((String)"10.0.101.1");
    private static final IpAddress IP5 = IpAddress.valueOf((String)"10.0.201.1");
    public static final IpAddress IP_NON_EXIST = IpAddress.valueOf((String)"10.101.1.1");
    public static final VlanId NO_VLAN = VlanId.NONE;
    public static final ConnectPoint CONNECT_POINT1 = ConnectPoint.deviceConnectPoint((String)"of:0000000000000001/1");
    public static final ConnectPoint CONNECT_POINT2 = ConnectPoint.deviceConnectPoint((String)"of:00000000000000a3/1");
    private static final String JSON_TREE = "{\"bgpSpeakers\" : [{\"name\" : \"bgp1\",\"connectPoint\" : \"of:0000000000000001/1\",\"peers\" : [\"10.0.1.1\",\"10.0.2.1\",\"10.0.3.1\"]}]}";
    private static final String EMPTY_JSON_TREE = "{}";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigApplyDelegate delegate = new MockCfgDelegate();
    private final BgpConfig.BgpSpeakerConfig initialSpeaker = this.createInitialSpeaker();
    private Set<BgpConfig.BgpSpeakerConfig> speakers = new HashSet<BgpConfig.BgpSpeakerConfig>();
    private BgpConfig bgpConfig = new BgpConfig();
    private BgpConfig emptyBgpConfig = new BgpConfig();

    @Before
    public void setUp() throws Exception {
        JsonNode tree = new ObjectMapper().readTree(JSON_TREE);
        this.bgpConfig.init((Object)APP_ID, "bgp-test", tree, this.mapper, this.delegate);
        JsonNode emptyTree = new ObjectMapper().readTree(EMPTY_JSON_TREE);
        this.emptyBgpConfig.init((Object)APP_ID, "bgp-test", emptyTree, this.mapper, this.delegate);
        this.speakers.add(this.initialSpeaker);
    }

    @Test
    public void testBgpSpeakers() throws Exception {
        TestCase.assertEquals(this.speakers, (Object)this.bgpConfig.bgpSpeakers());
    }

    @Test
    public void testEmptyBgpSpeakers() throws Exception {
        Assert.assertTrue((boolean)this.emptyBgpConfig.bgpSpeakers().isEmpty());
    }

    @Test
    public void testGetSpeakerWithName() throws Exception {
        junit.framework.Assert.assertNotNull((Object)this.bgpConfig.getSpeakerWithName("bgp1"));
        junit.framework.Assert.assertNull((Object)this.bgpConfig.getSpeakerWithName("bgp2"));
    }

    @Test
    public void testAddSpeaker() throws Exception {
        int initialSize = this.bgpConfig.bgpSpeakers().size();
        BgpConfig.BgpSpeakerConfig newSpeaker = this.createNewSpeaker();
        this.bgpConfig.addSpeaker(newSpeaker);
        TestCase.assertEquals((int)(initialSize + 1), (int)this.bgpConfig.bgpSpeakers().size());
        this.speakers.add(newSpeaker);
        TestCase.assertEquals(this.speakers, (Object)this.bgpConfig.bgpSpeakers());
    }

    @Test
    public void testAddSpeakerToEmpty() throws Exception {
        BgpConfig.BgpSpeakerConfig newSpeaker = this.createNewSpeaker();
        this.emptyBgpConfig.addSpeaker(newSpeaker);
        Assert.assertFalse((boolean)this.emptyBgpConfig.bgpSpeakers().isEmpty());
    }

    @Test
    public void testRemoveExistingSpeaker() throws Exception {
        int initialSize = this.bgpConfig.bgpSpeakers().size();
        this.bgpConfig.removeSpeaker("bgp1");
        TestCase.assertEquals((int)(initialSize - 1), (int)this.bgpConfig.bgpSpeakers().size());
    }

    @Test
    public void testRemoveInexistingSpeaker() throws Exception {
        int initialSize = this.bgpConfig.bgpSpeakers().size();
        this.bgpConfig.removeSpeaker("bgp2");
        TestCase.assertEquals((int)initialSize, (int)this.bgpConfig.bgpSpeakers().size());
    }

    @Test
    public void testAddPeerToSpeaker() throws Exception {
        int initialSize = this.bgpConfig.getSpeakerWithName("bgp1").peers().size();
        this.bgpConfig.addPeerToSpeaker("bgp1", IP4);
        TestCase.assertEquals((int)(initialSize + 1), (int)this.bgpConfig.getSpeakerWithName("bgp1").peers().size());
    }

    @Test
    public void testAddExistingPeerToSpeaker() throws Exception {
        int initialSize = this.bgpConfig.getSpeakerWithName("bgp1").peers().size();
        this.bgpConfig.addPeerToSpeaker("bgp1", IP1);
        TestCase.assertEquals((int)initialSize, (int)this.bgpConfig.getSpeakerWithName("bgp1").peers().size());
    }

    @Test
    public void testGetSpeakerFromPeer() throws Exception {
        junit.framework.Assert.assertNotNull((Object)this.bgpConfig.getSpeakerFromPeer(IP1));
        junit.framework.Assert.assertNull((Object)this.bgpConfig.getSpeakerFromPeer(IP_NON_EXIST));
    }

    @Test
    public void testRemoveExistingPeerFromSpeaker() throws Exception {
        int initialSize = this.bgpConfig.getSpeakerWithName("bgp1").peers().size();
        this.bgpConfig.removePeerFromSpeaker(this.initialSpeaker, IP1);
        TestCase.assertEquals((int)(initialSize - 1), (int)this.bgpConfig.getSpeakerWithName("bgp1").peers().size());
    }

    @Test
    public void testRemoveNonExistingPeerFromSpeaker() throws Exception {
        int initialSize = this.bgpConfig.getSpeakerWithName("bgp1").peers().size();
        this.bgpConfig.removePeerFromSpeaker(this.initialSpeaker, IP_NON_EXIST);
        TestCase.assertEquals((int)initialSize, (int)this.bgpConfig.getSpeakerWithName("bgp1").peers().size());
    }

    @Test
    public void testIsConnectedToPeer() {
        BgpConfig.BgpSpeakerConfig speaker = this.createNewSpeaker();
        Assert.assertTrue((boolean)speaker.isConnectedToPeer(IP4));
        Assert.assertFalse((boolean)speaker.isConnectedToPeer(IP_NON_EXIST));
    }

    private BgpConfig.BgpSpeakerConfig createInitialSpeaker() {
        Optional<String> speakerName = Optional.of("bgp1");
        ConnectPoint connectPoint = CONNECT_POINT1;
        HashSet<IpAddress> connectedPeers = new HashSet<IpAddress>(Arrays.asList(IP1, IP2, IP3));
        return new BgpConfig.BgpSpeakerConfig(speakerName, NO_VLAN, connectPoint, connectedPeers);
    }

    private BgpConfig.BgpSpeakerConfig createNewSpeaker() {
        Optional<String> speakerName = Optional.of("newSpeaker");
        ConnectPoint connectPoint = CONNECT_POINT2;
        HashSet<IpAddress> connectedPeers = new HashSet<IpAddress>(Arrays.asList(IP4, IP5));
        return new BgpConfig.BgpSpeakerConfig(speakerName, NO_VLAN, connectPoint, connectedPeers);
    }

    private class MockCfgDelegate
    implements ConfigApplyDelegate {
        private MockCfgDelegate() {
        }

        public void onApply(Config config) {
            config.apply();
        }
    }
}

