/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import org.onlab.packet.Ip6Prefix;

public final class Ip6PrefixSerializer
extends Serializer<Ip6Prefix> {
    public Ip6PrefixSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, Ip6Prefix object) {
        byte[] octs = object.address().toOctets();
        output.writeInt(octs.length);
        output.writeBytes(octs);
        output.writeInt(object.prefixLength());
    }

    public Ip6Prefix read(Kryo kryo, Input input, Class<Ip6Prefix> type) {
        int octLen = input.readInt();
        Preconditions.checkArgument((octLen <= 16 ? 1 : 0) != 0);
        byte[] octs = new byte[octLen];
        input.readBytes(octs);
        int prefLen = input.readInt();
        return Ip6Prefix.valueOf((byte[])octs, (int)prefLen);
    }
}

