/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.drivers.cisco.XmlParserCisco;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.device.DefaultDeviceInterfaceDescription;
import org.onosproject.net.device.DeviceInterfaceDescription;

public class XmlParserCiscoTest {
    private static final String INTF_NAME_1 = "GigabitEthernet0/1";
    private static final String INTF_NAME_2 = "GigabitEthernet0/2";
    private static final String INTF_NAME_3 = "GigabitEthernet0/3";
    private static final String INTF_NAME_4 = "GigabitEthernet0/4";
    private static final String INTF_NAME_5 = "GigabitEthernet0/5";
    private static final VlanId ACCESS_VLAN = VlanId.vlanId((short)100);
    private static final VlanId TRUNK_VLAN_1 = VlanId.vlanId((short)200);
    private static final VlanId TRUNK_VLAN_2 = VlanId.vlanId((short)201);
    private static final VlanId TRUNK_VLAN_3 = VlanId.vlanId((short)300);
    private static final VlanId TRUNK_VLAN_4 = VlanId.vlanId((short)301);
    private static final VlanId TRUNK_VLAN_5 = VlanId.vlanId((short)302);
    private static final short NO_RATE_LIMIT = -1;
    private static final short RATE_LIMIT_1 = 75;
    private static final short RATE_LIMIT_2 = 50;
    private static final boolean NO_LIMIT = false;
    private static final boolean WITH_LIMIT = true;
    private static final String CONFIG_XML_FILE = "/testGetConfig.xml";

    @Test
    public void controllersConfig() {
        InputStream streamOrig = this.getClass().getResourceAsStream(CONFIG_XML_FILE);
        HierarchicalConfiguration cfgOrig = XmlConfigParser.loadXml((InputStream)streamOrig);
        List actualIntfs = XmlParserCisco.getInterfacesFromConfig((HierarchicalConfiguration)cfgOrig);
        Assert.assertEquals((String)"Interfaces were not retrieved from configuration", this.getExpectedIntfs(), (Object)actualIntfs);
    }

    private List<DeviceInterfaceDescription> getExpectedIntfs() {
        ArrayList<DeviceInterfaceDescription> intfs = new ArrayList<DeviceInterfaceDescription>();
        intfs.add((DeviceInterfaceDescription)new DefaultDeviceInterfaceDescription(INTF_NAME_1, DeviceInterfaceDescription.Mode.NORMAL, (List)Lists.newArrayList(), false, -1));
        ArrayList<VlanId> accessList = new ArrayList<VlanId>();
        accessList.add(ACCESS_VLAN);
        intfs.add((DeviceInterfaceDescription)new DefaultDeviceInterfaceDescription(INTF_NAME_2, DeviceInterfaceDescription.Mode.ACCESS, accessList, false, -1));
        ArrayList<VlanId> trunkList1 = new ArrayList<VlanId>();
        trunkList1.add(TRUNK_VLAN_1);
        trunkList1.add(TRUNK_VLAN_2);
        intfs.add((DeviceInterfaceDescription)new DefaultDeviceInterfaceDescription(INTF_NAME_3, DeviceInterfaceDescription.Mode.TRUNK, trunkList1, false, -1));
        intfs.add((DeviceInterfaceDescription)new DefaultDeviceInterfaceDescription(INTF_NAME_4, DeviceInterfaceDescription.Mode.NORMAL, (List)Lists.newArrayList(), true, 75));
        ArrayList<VlanId> trunkList2 = new ArrayList<VlanId>();
        trunkList2.add(TRUNK_VLAN_3);
        trunkList2.add(TRUNK_VLAN_4);
        trunkList2.add(TRUNK_VLAN_5);
        intfs.add((DeviceInterfaceDescription)new DefaultDeviceInterfaceDescription(INTF_NAME_5, DeviceInterfaceDescription.Mode.TRUNK, trunkList2, true, 50));
        return intfs;
    }
}

