/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;

public class Ofdpa3MatchOvidCodec
extends JsonCodec<Ofdpa3MatchOvid> {
    private static final String OVID = "oVid";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Ofdpa3MatchOvid";
    private static final String MISSING_OVID_MESSAGE = "OVID cannot be null";

    public ObjectNode encode(Ofdpa3MatchOvid matchOvid, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)matchOvid), (Object)MISSING_OVID_MESSAGE);
        return context.mapper().createObjectNode().put(OVID, (Short)matchOvid.vlanId().id());
    }

    public Ofdpa3MatchOvid decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        short vlanVid = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(OVID), (String)"oVid member is required in Ofdpa3MatchOvid")).asInt();
        return new Ofdpa3MatchOvid(VlanId.vlanId((short)vlanVid));
    }
}

