/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.pipeline.DefaultSingleTablePipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackPipeline
extends DefaultSingleTablePipeline
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CoreService coreService;
    private ServiceDirectory serviceDirectory;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    protected FlowRuleService flowRuleService;
    protected static final int VNI_TABLE = 0;
    protected static final int FORWARDING_TABLE = 1;
    protected static final int ACL_TABLE = 2;
    private static final int DROP_PRIORITY = 0;
    private static final int TIME_OUT = 0;
    private static final int DHCP_SERVER_PORT = 67;
    private static final int DHCP_CLIENT_PORT = 68;

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        super.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = context.store();
        this.appId = this.coreService.registerApplication("org.onosproject.driver.OpenstackPipeline");
        this.initializePipeline();
    }

    @Override
    public void filter(FilteringObjective filteringObjective) {
        super.filter(filteringObjective);
    }

    @Override
    public void next(NextObjective nextObjective) {
        super.next(nextObjective);
    }

    @Override
    public void forward(final ForwardingObjective forwardingObjective) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(forwardingObjective);
        switch (forwardingObjective.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)forwardingObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}");
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OpenstackPipeline.this.pass((Objective)forwardingObjective);
            }

            public void onError(FlowRuleOperations ops) {
                OpenstackPipeline.this.fail((Objective)forwardingObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private void initializePipeline() {
        this.processVniTable(true);
        this.processForwardingTable(true);
        this.processAclTable(true);
    }

    private void processVniTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(1));
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(0).build();
        this.applyRules(install, flowRule);
    }

    private void processForwardingTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.drop();
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(1).build();
        this.applyRules(install, flowRule);
    }

    private void processAclTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.wipeDeferred();
        treatment.drop();
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(2).build();
        this.applyRules(install, flowRule);
    }

    private void applyRules(boolean install, FlowRule flowRule) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        flowOpsBuilder = install ? flowOpsBuilder.add(flowRule) : flowOpsBuilder.remove(flowRule);
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OpenstackPipeline.this.log.debug("Provisioned vni or forwarding table");
            }

            public void onError(FlowRuleOperations ops) {
                OpenstackPipeline.this.log.debug("Failed to privision vni or forwarding table");
            }
        }));
    }

    private Collection<FlowRule> processForward(ForwardingObjective forwardingObjective) {
        switch (forwardingObjective.flag()) {
            case SPECIFIC: {
                return this.processSpecific(forwardingObjective);
            }
            case VERSATILE: {
                return this.processVersatile(forwardingObjective);
            }
        }
        this.fail((Objective)forwardingObjective, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)forwardingObjective.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective forwardingObjective) {
        this.log.debug("Processing versatile forwarding objective");
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(forwardingObjective.selector()).withTreatment(forwardingObjective.treatment()).withPriority(forwardingObjective.priority()).fromApp(forwardingObjective.appId());
        if (forwardingObjective.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(0);
        }
        EthTypeCriterion ethCriterion = (EthTypeCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.ETH_TYPE);
        UdpPortCriterion udpPortCriterion = (UdpPortCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.UDP_DST);
        if (ethCriterion != null) {
            if (ethCriterion.ethType().toShort() == Ethernet.TYPE_ARP || ethCriterion.ethType().toShort() == Ethernet.TYPE_LLDP) {
                ruleBuilder.forTable(0);
                return Collections.singletonList(ruleBuilder.build());
            }
            if (udpPortCriterion != null && udpPortCriterion.udpPort().toInt() == 67) {
                ruleBuilder.forTable(0);
                return Collections.singletonList(ruleBuilder.build());
            }
        }
        return Collections.emptySet();
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective forwardingObjective) {
        this.log.debug("Processing specific forwarding objective");
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(forwardingObjective.selector()).withTreatment(forwardingObjective.treatment()).withPriority(forwardingObjective.priority()).fromApp(forwardingObjective.appId());
        if (forwardingObjective.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(0);
        }
        if (forwardingObjective.selector().getCriterion(Criterion.Type.IN_PORT) != null) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            forwardingObjective.treatment().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)tBuilder).add(arg_0));
            tBuilder.transition(Integer.valueOf(1));
            ruleBuilder.withTreatment(tBuilder.build());
            ruleBuilder.forTable(0);
        } else if (forwardingObjective.selector().getCriterion(Criterion.Type.TUNNEL_ID) != null) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            tBuilder.deferred();
            forwardingObjective.treatment().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)tBuilder).add(arg_0));
            tBuilder.transition(Integer.valueOf(2));
            ruleBuilder.withTreatment(tBuilder.build());
            ruleBuilder.forTable(1);
        } else {
            ruleBuilder.forTable(2);
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }
}

