/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraMatchNshSi;
import org.onosproject.net.NshServiceIndex;

public final class NiciraMatchNshSiCodec
extends JsonCodec<NiciraMatchNshSi> {
    private static final String NSH_SERVICE_INDEX = "nsi";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraMatchNshSi";

    public ObjectNode encode(NiciraMatchNshSi niciraMatchNshSi, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraMatchNshSi), (Object)"Nicira Match Nsh Si cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(NSH_SERVICE_INDEX, niciraMatchNshSi.nshSi().serviceIndex());
        return root;
    }

    public NiciraMatchNshSi decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        short nshSiShort = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(NSH_SERVICE_INDEX), (String)"nsi member is required in NiciraMatchNshSi")).asInt();
        NshServiceIndex nshSi = NshServiceIndex.of((short)nshSiShort);
        return new NiciraMatchNshSi(nshSi);
    }
}

