/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.packet.VlanId;
import org.onosproject.codec.CodecContext;
import org.onosproject.driver.extensions.Ofdpa3MatchMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;
import org.onosproject.driver.extensions.OfdpaMatchActsetOutput;
import org.onosproject.driver.extensions.OfdpaMatchAllowVlanTranslation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaActsetOutput;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaAllowVlanTranslation;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsL2Port;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaOvid;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3ExtensionSelectorInterpreter
extends AbstractHandlerBehaviour
implements ExtensionSelectorInterpreter,
ExtensionSelectorResolver {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean supported(ExtensionSelectorType extensionSelectorType) {
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            return true;
        }
        return extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type());
    }

    public OFOxm<?> mapSelector(OFFactory factory, ExtensionSelector extensionSelector) {
        ExtensionSelectorType type = extensionSelector.type();
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            VlanId vlanId = ((Ofdpa3MatchOvid)extensionSelector).vlanId();
            if (vlanId.equals((Object)VlanId.NONE)) {
                throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
            }
            if (vlanId.equals((Object)VlanId.ANY)) {
                throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
            }
            int mask = 4096;
            short oVid = (short)(mask | vlanId.toShort());
            return factory.oxms().ofdpaOvid(U16.ofRaw((short)oVid));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type())) {
            int mplsL2Port = ((Ofdpa3MatchMplsL2Port)extensionSelector).mplsL2Port();
            if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                return factory.oxms().ofdpaMplsL2Port(U32.ofRaw((int)mplsL2Port));
            }
            throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            PortNumber port = ((OfdpaMatchActsetOutput)extensionSelector).port();
            return factory.oxms().ofdpaActsetOutput(U32.of((long)port.toLong()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type())) {
            Short allowVlanTranslation = ((OfdpaMatchAllowVlanTranslation)extensionSelector).allowVlanTranslation();
            return factory.oxms().ofdpaAllowVlanTranslation(U8.of((short)allowVlanTranslation));
        }
        throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
    }

    public ExtensionSelector mapOxm(OFOxm<?> oxm) {
        if (oxm.getMatchField().equals(MatchField.OFDPA_OVID)) {
            if (oxm.isMasked()) {
                throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
            }
            OFOxmOfdpaOvid ovid = (OFOxmOfdpaOvid)oxm;
            int mask = 4095;
            short oVid = (short)(mask & ovid.getValue().getRaw());
            VlanId vlanId = VlanId.vlanId((short)oVid);
            return new Ofdpa3MatchOvid(vlanId);
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_MPLS_L2_PORT)) {
            if (oxm.isMasked()) {
                throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
            }
            OFOxmOfdpaMplsL2Port mplsl2port = (OFOxmOfdpaMplsL2Port)oxm;
            Integer mplsL2Port = mplsl2port.getValue().getRaw();
            if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                return new Ofdpa3MatchMplsL2Port(mplsL2Port);
            }
            throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_ACTSET_OUTPUT)) {
            U32 portNumberU32 = ((OFOxmOfdpaActsetOutput)oxm).getValue();
            PortNumber portNumber = PortNumber.portNumber((long)portNumberU32.getValue());
            return new OfdpaMatchActsetOutput(portNumber);
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_ALLOW_VLAN_TRANSLATION)) {
            U8 value = ((OFOxmOfdpaAllowVlanTranslation)oxm).getValue();
            return new OfdpaMatchAllowVlanTranslation(value.getValue());
        }
        throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
    }

    public ExtensionSelector getExtensionSelector(ExtensionSelectorType type) {
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_OVID.type())) {
            return new Ofdpa3MatchOvid();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_MPLS_L2_PORT.type())) {
            return new Ofdpa3MatchMplsL2Port();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            return new OfdpaMatchActsetOutput();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type())) {
            return new OfdpaMatchAllowVlanTranslation();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }

    public ObjectNode encode(ExtensionSelector extensionSelector, CodecContext context) {
        this.log.warn("The encode method of Ofdpa3ExtensionSelectorInterpreter hasn't been implemented");
        return null;
    }

    public ExtensionSelector decode(ObjectNode json, CodecContext context) {
        this.log.warn("The decode method of Ofdpa3ExtensionSelectorInterpreter hasn't been implemented");
        return null;
    }
}

