/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.Ofdpa3SetQosIndex;

public class Ofdpa3SetQosIndexCodec
extends JsonCodec<Ofdpa3SetQosIndex> {
    private static final String QOS_INDEX = "qosIndex";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Ofdpa3SetQosIndex";
    private static final String MISSING_QOS_INDEX_TYPE_MESSAGE = "qosIndex cannot be null";

    public ObjectNode encode(Ofdpa3SetQosIndex qosIndex, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)qosIndex), (Object)MISSING_QOS_INDEX_TYPE_MESSAGE);
        return context.mapper().createObjectNode().put(QOS_INDEX, qosIndex.qosIndex());
    }

    public Ofdpa3SetQosIndex decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int qosIndex = ((JsonNode)Tools.nullIsIllegal((Object)json.get(QOS_INDEX), (String)"qosIndex member is required in Ofdpa3SetQosIndex")).asInt();
        return new Ofdpa3SetQosIndex(qosIndex);
    }
}

