/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.handshaker;

import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuniperSwitchHandshaker
extends AbstractOpenFlowSwitch {
    private static final int LOWEST_PRIORITY = 0;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        if (this.factory().getVersion() == OFVersion.OF_10) {
            OFFlowAdd.Builder fmBuilder = this.factory().buildFlowAdd();
            fmBuilder.setPriority(0);
            this.sendHandshakeMessage((OFMessage)fmBuilder.build());
        }
        this.log.debug("Juniper Switch Operating OF version {}", (Object)this.factory().getVersion());
    }

    public boolean isDriverHandshakeComplete() {
        return true;
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        this.log.debug("Juniper Switch: processDriverHandshakeMessage for sw {}", (Object)this.getStringId());
    }

    public void setRole(RoleState role) {
        this.log.warn("Juniper switch dosen't support OpenFlow Role Request/Reply message");
        if (this.role == null) {
            this.role = role;
        }
    }

    public void handleRole(OFMessage m) throws SwitchStateException {
        this.log.warn("Juniper switch dosen't support OpenFlow Role Request/Reply message");
    }
}

