/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;

public final class OfdpaPipelineUtility {
    static final int PORT_TABLE = 0;
    static final int VLAN_TABLE = 10;
    static final int VLAN_1_TABLE = 11;
    static final int MPLS_L2_PORT_FLOW_TABLE = 13;
    static final int MPLS_L2_PORT_PCP_TRUST_FLOW_TABLE = 16;
    static final int TMAC_TABLE = 20;
    static final int UNICAST_ROUTING_TABLE = 30;
    static final int MULTICAST_ROUTING_TABLE = 40;
    static final int MPLS_TABLE_0 = 23;
    static final int MPLS_TABLE_1 = 24;
    static final int MPLS_L3_TYPE_TABLE = 27;
    static final int MPLS_TYPE_TABLE = 29;
    static final int BRIDGING_TABLE = 50;
    public static final int ACL_TABLE = 60;
    static final int EGRESS_VLAN_FLOW_TABLE = 210;
    static final int EGRESS_DSCP_PCP_REMARK_FLOW_TABLE = 230;
    static final int EGRESS_TPID_FLOW_TABLE = 235;
    static final int MAC_LEARNING_TABLE = 254;
    static final long OFPP_MAX = 0xFFFFFF00L;
    static final int HIGHEST_PRIORITY = 65535;
    static final int DEFAULT_PRIORITY = 32768;
    static final int LOWEST_PRIORITY = 0;
    static final int MPLS_L2_PORT_PRIORITY = 2;
    static final int MPLS_TUNNEL_ID_BASE = 65536;
    static final int MPLS_TUNNEL_ID_MAX = 131071;
    static final int MPLS_UNI_PORT_MAX = 65535;
    static final int MPLS_NNI_PORT_BASE = 131072;
    static final int MPLS_NNI_PORT_MAX = 196607;
    static final short ALLOW_VLAN_TRANSLATION = 1;
    static final int COPY_FIELD_NBITS = 12;
    static final int COPY_FIELD_OFFSET = 0;
    static final int MAX_RETRY_ATTEMPTS = 10;
    static final int RETRY_MS = 1000;

    private OfdpaPipelineUtility() {
    }

    static boolean isAccumulatorEnabled(Ofdpa2Pipeline pipeline) {
        Driver driver = pipeline.data().driver();
        if (driver == null) {
            return false;
        }
        return Boolean.parseBoolean(driver.getProperty("accumulatorEnabled"));
    }

    static void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    static void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    static boolean isMplsBos(TrafficSelector selector) {
        MplsBosCriterion bosCriterion = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
        return bosCriterion != null && bosCriterion.mplsBos();
    }

    static boolean isNotMplsBos(TrafficSelector selector) {
        MplsBosCriterion bosCriterion = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
        return bosCriterion != null && !bosCriterion.mplsBos();
    }

    static boolean isMplsPop(ForwardingObjective fwd) {
        if (fwd.treatment() != null) {
            for (Instruction instr : fwd.treatment().allInstructions()) {
                if (!(instr instanceof L2ModificationInstruction) || ((L2ModificationInstruction)instr).subtype() != L2ModificationInstruction.L2SubType.MPLS_POP) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isIpv6(TrafficSelector selector) {
        EthTypeCriterion ethTypeCriterion = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        return ethTypeCriterion != null && ethTypeCriterion.ethType().toShort() == Ethernet.TYPE_IPV6;
    }

    static VlanId readVlanFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        Criterion criterion = selector.getCriterion(Criterion.Type.VLAN_VID);
        return criterion == null ? null : ((VlanIdCriterion)criterion).vlanId();
    }

    static MacAddress readEthDstFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        Criterion criterion = selector.getCriterion(Criterion.Type.ETH_DST);
        return criterion == null ? null : ((EthCriterion)criterion).mac();
    }

    static IpPrefix readIpDstFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        Criterion criterion = selector.getCriterion(Criterion.Type.IPV4_DST);
        return criterion == null ? null : ((IPCriterion)criterion).ip();
    }

    static VlanId readVlanFromTreatment(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction i : treatment.allInstructions()) {
            if (!(i instanceof L2ModificationInstruction.ModVlanIdInstruction)) continue;
            return ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
        }
        return null;
    }

    static MacAddress readEthDstFromTreatment(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction i : treatment.allInstructions()) {
            L2ModificationInstruction.ModEtherInstruction modEtherInstruction;
            if (!(i instanceof L2ModificationInstruction.ModEtherInstruction) || (modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)i).subtype() != L2ModificationInstruction.L2SubType.ETH_DST) continue;
            return modEtherInstruction.mac();
        }
        return null;
    }

    static ExtensionSelector readExtensionFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        ExtensionCriterion criterion = (ExtensionCriterion)selector.getCriterion(Criterion.Type.EXTENSION);
        return criterion == null ? null : criterion.extensionSelector();
    }

    static boolean isPseudowire(FilteringObjective filteringObjective) {
        if (filteringObjective.meta() != null) {
            TrafficTreatment treatment = filteringObjective.meta();
            for (Instruction instr : treatment.immediate()) {
                L2ModificationInstruction l2Instr;
                if (!instr.type().equals((Object)Instruction.Type.L2MODIFICATION) || !(l2Instr = (L2ModificationInstruction)instr).subtype().equals((Object)L2ModificationInstruction.L2SubType.TUNNEL_ID)) continue;
                return true;
            }
        }
        return false;
    }

    static L2ModificationInstruction.ModTunnelIdInstruction getModTunnelIdInstruction(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction instruction : treatment.allInstructions()) {
            L2ModificationInstruction l2ModificationInstruction;
            if (instruction.type() != Instruction.Type.L2MODIFICATION || (l2ModificationInstruction = (L2ModificationInstruction)instruction).subtype() != L2ModificationInstruction.L2SubType.TUNNEL_ID) continue;
            return (L2ModificationInstruction.ModTunnelIdInstruction)l2ModificationInstruction;
        }
        return null;
    }

    static Instructions.OutputInstruction getOutputInstruction(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction instruction : treatment.allInstructions()) {
            if (instruction.type() != Instruction.Type.OUTPUT) continue;
            return (Instructions.OutputInstruction)instruction;
        }
        return null;
    }

    static boolean isDoubleTagged(FilteringObjective fob) {
        return fob.meta() != null && fob.meta().allInstructions().stream().anyMatch(inst -> inst.type() == Instruction.Type.L2MODIFICATION && ((L2ModificationInstruction)inst).subtype() == L2ModificationInstruction.L2SubType.VLAN_POP) && fob.conditions().stream().anyMatch(criterion -> criterion.type() == Criterion.Type.VLAN_VID) && fob.conditions().stream().anyMatch(criterion -> criterion.type() == Criterion.Type.INNER_VLAN_VID);
    }
}

