/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.query;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.VlanQuery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;

@Beta
public class FullVlanAvailable
extends AbstractHandlerBehaviour
implements VlanQuery {
    private static final int MAX_VLAN_ID = 4095;
    private static final Set<Integer> EXCLUDED = ImmutableSet.of((Object)0, (Object)4095);
    private static final Set<VlanId> ENTIRE_VLAN = FullVlanAvailable.getEntireVlans();

    public Set<VlanId> queryVlanIds(PortNumber port) {
        return ENTIRE_VLAN;
    }

    private static Set<VlanId> getEntireVlans() {
        return (Set)IntStream.range(0, 4095).filter(x -> !EXCLUDED.contains(x)).mapToObj(x -> VlanId.vlanId((short)((short)x))).collect(ImmutableSet.toImmutableSet());
    }
}

