/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.driver.extensions.Ofdpa3CopyField;
import org.onosproject.driver.extensions.Ofdpa3PopCw;
import org.onosproject.driver.extensions.Ofdpa3PopL2Header;
import org.onosproject.driver.extensions.Ofdpa3PushCw;
import org.onosproject.driver.extensions.Ofdpa3PushL2Header;
import org.onosproject.driver.extensions.Ofdpa3SetMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.Ofdpa3SetOvid;
import org.onosproject.driver.extensions.Ofdpa3SetQosIndex;
import org.onosproject.driver.extensions.OfdpaSetAllowVlanTranslation;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionExperimenter;
import org.projectfloodlight.openflow.protocol.action.OFActionOfdpa;
import org.projectfloodlight.openflow.protocol.action.OFActionOnf;
import org.projectfloodlight.openflow.protocol.action.OFActionOnfCopyField;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaAllowVlanTranslation;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsL2Port;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsType;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaOvid;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaQosIndex;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3ExtensionTreatmentInterpreter
extends AbstractHandlerBehaviour
implements ExtensionTreatmentInterpreter,
ExtensionTreatmentResolver {
    private static final int TYPE_OFDPA = 4120;
    private static final int TYPE_ONF = 1330529792;
    private static final int SUB_TYPE_PUSH_L2_HEADER = 1;
    private static final int SUB_TYPE_POP_L2_HEADER = 2;
    private static final int SUB_TYPE_PUSH_CW = 3;
    private static final int SUB_TYPE_POP_CW = 4;
    private static final int SUB_TYPE_COPY_FIELD = 3200;
    private static final String TYPE = "type";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in Ofdpa3ExtensionTreatmentInterpreter";
    private static final String MISSING_TREATMENT_MESSAGE = "Extension treatment cannot be null";
    private static final String NOT_SUPPORTED_MESSAGE = "Driver does not support extension type of ";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean supported(ExtensionTreatmentType extensionTreatmentType) {
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.type())) {
            return true;
        }
        return extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.type());
    }

    public OFAction mapInstruction(OFFactory factory, ExtensionTreatment extensionTreatment) {
        ExtensionTreatmentType type = extensionTreatment.type();
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.type())) {
            short mplsType = ((Ofdpa3SetMplsType)extensionTreatment).mplsType();
            return factory.actions().setField((OFOxm)factory.oxms().ofdpaMplsType(U16.ofRaw((short)mplsType)));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.type())) {
            VlanId vlanId = ((Ofdpa3SetOvid)extensionTreatment).vlanId();
            int mask = 4096;
            short oVid = (short)(mask | vlanId.toShort());
            return factory.actions().setField((OFOxm)factory.oxms().ofdpaOvid(U16.ofRaw((short)oVid)));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.type())) {
            Integer mplsL2Port = ((Ofdpa3SetMplsL2Port)extensionTreatment).mplsL2Port();
            if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                return factory.actions().setField((OFOxm)factory.oxms().ofdpaMplsL2Port(U32.ofRaw((int)mplsL2Port)));
            }
            throw new UnsupportedOperationException("Unexpected ExtensionTreatment: " + extensionTreatment.toString());
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.type())) {
            Integer qosIndex = ((Ofdpa3SetQosIndex)extensionTreatment).qosIndex();
            if (qosIndex >= 0 && qosIndex <= 255) {
                return factory.actions().setField((OFOxm)factory.oxms().ofdpaQosIndex(U8.ofRaw((byte)((byte)(qosIndex & 0xFF)))));
            }
            throw new UnsupportedOperationException("Unexpected ExtensionTreatment: " + extensionTreatment.toString());
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.type())) {
            return factory.actions().ofdpaPushL2Header();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.type())) {
            return factory.actions().ofdpaPushCw();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.type())) {
            return factory.actions().ofdpaPopL2Header();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.type())) {
            return factory.actions().ofdpaPopCw();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.type())) {
            byte allow = ((OfdpaSetAllowVlanTranslation)extensionTreatment).getVlanTranslation();
            return factory.actions().setField((OFOxm)factory.oxms().ofdpaAllowVlanTranslation(U8.ofRaw((byte)allow)));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.type())) {
            Ofdpa3CopyField copyField = (Ofdpa3CopyField)extensionTreatment;
            return factory.actions().buildOnfCopyField().setDstOffset(copyField.getDstOffset()).setSrcOffset(copyField.getSrcOffset()).setNBits(copyField.getnBits()).setSrc((long)copyField.getSrc()).setDst((long)copyField.getDst()).build();
        }
        throw new UnsupportedOperationException("Unexpected ExtensionTreatment: " + extensionTreatment.toString());
    }

    public ExtensionTreatment mapAction(OFAction action) throws UnsupportedOperationException {
        block23: {
            block22: {
                if (!action.getType().equals((Object)OFActionType.SET_FIELD)) break block22;
                OFActionSetField setFieldAction = (OFActionSetField)action;
                OFOxm oxm = setFieldAction.getField();
                switch (oxm.getMatchField().id) {
                    case OFDPA_MPLS_TYPE: {
                        OFOxmOfdpaMplsType mplsType = (OFOxmOfdpaMplsType)oxm;
                        return new Ofdpa3SetMplsType(mplsType.getValue().getRaw());
                    }
                    case OFDPA_OVID: {
                        OFOxmOfdpaOvid ovid = (OFOxmOfdpaOvid)oxm;
                        int mask = 4095;
                        short oVid = (short)(mask & ovid.getValue().getRaw());
                        VlanId vlanId = VlanId.vlanId((short)oVid);
                        return new Ofdpa3SetOvid(vlanId);
                    }
                    case OFDPA_MPLS_L2_PORT: {
                        OFOxmOfdpaMplsL2Port mplsl2Port = (OFOxmOfdpaMplsL2Port)oxm;
                        Integer mplsL2Port = mplsl2Port.getValue().getRaw();
                        if (mplsL2Port >= 0 && mplsL2Port <= 65535 || mplsL2Port >= 131072 && mplsL2Port <= 196607) {
                            return new Ofdpa3SetMplsL2Port(mplsL2Port);
                        }
                        break block23;
                    }
                    case OFDPA_QOS_INDEX: {
                        OFOxmOfdpaQosIndex qosindex = (OFOxmOfdpaQosIndex)oxm;
                        Integer qosIndex = qosindex.getValue().getRaw();
                        if (qosIndex >= 0 && qosIndex <= 255) {
                            return new Ofdpa3SetQosIndex(qosIndex);
                        }
                        break block23;
                    }
                    case OFDPA_ALLOW_VLAN_TRANSLATION: {
                        OFOxmOfdpaAllowVlanTranslation allowVlanTranslation = (OFOxmOfdpaAllowVlanTranslation)oxm;
                        Byte allowVlan = allowVlanTranslation.getValue().getRaw();
                        if (allowVlan == 0 || allowVlan == 1) {
                            return new OfdpaSetAllowVlanTranslation(allowVlan);
                        }
                        break block23;
                    }
                    default: {
                        throw new UnsupportedOperationException("Driver does not support extension type " + oxm.getMatchField().id);
                    }
                }
            }
            if (action.getType().equals((Object)OFActionType.EXPERIMENTER)) {
                OFActionExperimenter experimenter = (OFActionExperimenter)action;
                if (Long.valueOf(experimenter.getExperimenter()).intValue() == 4120) {
                    OFActionOfdpa ofdpa = (OFActionOfdpa)experimenter;
                    switch (ofdpa.getExpType()) {
                        case 1: {
                            return new Ofdpa3PushL2Header();
                        }
                        case 2: {
                            return new Ofdpa3PopL2Header();
                        }
                        case 3: {
                            return new Ofdpa3PushCw();
                        }
                        case 4: {
                            return new Ofdpa3PopCw();
                        }
                    }
                    throw new UnsupportedOperationException("Unexpected OFAction: " + action.toString());
                }
                if (Long.valueOf(experimenter.getExperimenter()).intValue() == 1330529792) {
                    OFActionOnf onf = (OFActionOnf)experimenter;
                    switch (onf.getExpType()) {
                        case 3200: {
                            return new Ofdpa3CopyField(((OFActionOnfCopyField)onf).getNBits(), ((OFActionOnfCopyField)onf).getSrcOffset(), ((OFActionOnfCopyField)onf).getDstOffset(), (int)((OFActionOnfCopyField)onf).getSrc(), (int)((OFActionOnfCopyField)onf).getDst());
                        }
                    }
                    throw new UnsupportedOperationException("Unexpected OFAction: " + action.toString());
                }
                throw new UnsupportedOperationException("Unexpected OFAction: " + action.toString());
            }
        }
        throw new UnsupportedOperationException("Unexpected OFAction: " + action.toString());
    }

    public ExtensionTreatment getExtensionInstruction(ExtensionTreatmentType type) {
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.type())) {
            return new Ofdpa3SetMplsType();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.type())) {
            return new Ofdpa3SetOvid();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.type())) {
            return new Ofdpa3SetMplsL2Port();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.type())) {
            return new Ofdpa3SetQosIndex();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.type())) {
            return new Ofdpa3PushL2Header();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.type())) {
            return new Ofdpa3PushCw();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.type())) {
            return new Ofdpa3PopL2Header();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.type())) {
            return new Ofdpa3PopCw();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.type())) {
            return new OfdpaSetAllowVlanTranslation();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.type())) {
            return new Ofdpa3CopyField();
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE + type.toString());
    }

    public ObjectNode encode(ExtensionTreatment extensionTreatment, CodecContext context) {
        Preconditions.checkNotNull((Object)extensionTreatment, (Object)MISSING_TREATMENT_MESSAGE);
        ExtensionTreatmentType type = extensionTreatment.type();
        ObjectNode root = context.mapper().createObjectNode();
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.type())) {
            Ofdpa3SetMplsType setMplsType = (Ofdpa3SetMplsType)extensionTreatment;
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.name());
            root.setAll(context.codec(Ofdpa3SetMplsType.class).encode((Object)setMplsType, context));
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.type())) {
            Ofdpa3SetOvid setOvid = (Ofdpa3SetOvid)extensionTreatment;
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.name());
            root.setAll(context.codec(Ofdpa3SetOvid.class).encode((Object)setOvid, context));
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.type())) {
            Ofdpa3SetMplsL2Port setMplsL2Port = (Ofdpa3SetMplsL2Port)extensionTreatment;
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.name());
            root.setAll(context.codec(Ofdpa3SetMplsL2Port.class).encode((Object)setMplsL2Port, context));
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.type())) {
            Ofdpa3SetQosIndex setQosIndex = (Ofdpa3SetQosIndex)extensionTreatment;
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.name());
            root.setAll(context.codec(Ofdpa3SetQosIndex.class).encode((Object)setQosIndex, context));
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.name());
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.name());
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.name());
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.name());
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.name());
        } else if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.type())) {
            root.put(TYPE, ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.name());
        }
        return root;
    }

    public ExtensionTreatment decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        String type = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in Ofdpa3ExtensionTreatmentInterpreter")).asText();
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_TYPE.name())) {
            return (ExtensionTreatment)context.codec(Ofdpa3SetMplsType.class).decode(json, context);
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_OVID.name())) {
            return (ExtensionTreatment)context.codec(Ofdpa3SetOvid.class).decode(json, context);
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_MPLS_L2_PORT.name())) {
            return (ExtensionTreatment)context.codec(Ofdpa3SetMplsL2Port.class).decode(json, context);
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_QOS_INDEX.name())) {
            return (ExtensionTreatment)context.codec(Ofdpa3SetQosIndex.class).decode(json, context);
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_L2_HEADER.name())) {
            return new Ofdpa3PushL2Header();
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_PUSH_CW.name())) {
            return new Ofdpa3PushCw();
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_L2_HEADER.name())) {
            return new Ofdpa3PopL2Header();
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_POP_CW.name())) {
            return new Ofdpa3PopCw();
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_ALLOW_VLAN_TRANSLATION.name())) {
            return new OfdpaSetAllowVlanTranslation();
        }
        if (type.equals(ExtensionTreatmentType.ExtensionTreatmentTypes.ONF_COPY_FIELD.name())) {
            return new Ofdpa3CopyField();
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE + type.toString());
    }
}

