/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import org.onlab.packet.VlanId;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;

public class OfdpaExtensionTreatmentInterpreter
extends AbstractHandlerBehaviour
implements ExtensionTreatmentInterpreter,
ExtensionTreatmentResolver {
    public boolean supported(ExtensionTreatmentType extensionTreatmentType) {
        return extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_VLAN_ID.type());
    }

    public OFAction mapInstruction(OFFactory factory, ExtensionTreatment extensionTreatment) {
        ExtensionTreatmentType type = extensionTreatment.type();
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_VLAN_ID.type())) {
            VlanId vlanId = ((OfdpaSetVlanVid)extensionTreatment).vlanId();
            OFVlanVidMatch match = OFVlanVidMatch.ofRawVid((short)vlanId.toShort());
            return factory.actions().setField((OFOxm)factory.oxms().vlanVid(match));
        }
        throw new UnsupportedOperationException("Unexpected ExtensionTreatment: " + extensionTreatment.toString());
    }

    public ExtensionTreatment mapAction(OFAction action) throws UnsupportedOperationException {
        if (action.getType().equals((Object)OFActionType.SET_FIELD)) {
            OFActionSetField setFieldAction = (OFActionSetField)action;
            OFOxm oxm = setFieldAction.getField();
            switch (oxm.getMatchField().id) {
                case VLAN_VID: {
                    OFOxmVlanVid vlanVid = (OFOxmVlanVid)oxm;
                    return new OfdpaSetVlanVid(VlanId.vlanId((short)vlanVid.getValue().getRawVid()));
                }
            }
            throw new UnsupportedOperationException("Driver does not support extension type " + oxm.getMatchField().id);
        }
        throw new UnsupportedOperationException("Unexpected OFAction: " + action.toString());
    }

    public ExtensionTreatment getExtensionInstruction(ExtensionTreatmentType type) {
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.OFDPA_SET_VLAN_ID.type())) {
            return new OfdpaSetVlanVid();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }
}

