/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onlab.packet.IpAddress;
import org.onosproject.driver.extensions.NiciraNat;

public class NiciraNatSerializer
extends Serializer<NiciraNat> {
    public NiciraNatSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, NiciraNat object) {
        output.writeInt(object.niciraNatFlags());
        output.writeInt(object.niciraNatPresentFlags());
        output.writeInt(object.niciraNatPortMin());
        output.writeInt(object.niciraNatPortMax());
        output.writeBytes(object.niciraNatIpAddressMin().toOctets());
        output.writeBytes(object.niciraNatIpAddressMax().toOctets());
    }

    public NiciraNat read(Kryo kryo, Input input, Class<NiciraNat> type) {
        int natFlags = input.readInt();
        int natPresentFlags = input.readInt();
        int natPortMin = input.readInt();
        int natPortMax = input.readInt();
        byte[] minOcts = new byte[4];
        byte[] maxOcts = new byte[4];
        input.readBytes(minOcts);
        input.readBytes(maxOcts);
        IpAddress natIpAddressMin = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])minOcts);
        IpAddress natIpAddressMax = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])maxOcts);
        return new NiciraNat(natFlags, natPresentFlags, natPortMin, natPortMax, natIpAddressMin, natIpAddressMax);
    }
}

