/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.traceable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.onlab.packet.EthType;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.OvsOfdpaPipeline;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DataPlaneEntity;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PipelineTraceableHitChain;
import org.onosproject.net.PipelineTraceableInput;
import org.onosproject.net.PipelineTraceableOutput;
import org.onosproject.net.PipelineTraceablePacket;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.PipelineTraceable;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdpaPipelineTraceable
extends AbstractHandlerBehaviour
implements PipelineTraceable {
    private static final Logger log = LoggerFactory.getLogger(OfdpaPipelineTraceable.class);
    private DeviceId deviceId;
    private String driverName;
    private final Comparator<FlowEntry> comparatorById = Comparator.comparing(f -> (Integer)((IndexTableId)f.table()).id());
    private final Comparator<FlowEntry> comparatorByPriority = Comparator.comparing(FlowRule::priority);

    public void init() {
        this.deviceId = this.data().deviceId();
        this.driverName = this.data().driver().name();
    }

    public PipelineTraceableOutput apply(PipelineTraceableInput input) {
        FlowEntry flowEntry;
        PipelineTraceableOutput.Builder outputBuilder = PipelineTraceableOutput.builder();
        log.debug("Current packet {} - applying flow tables", (Object)input.ingressPacket());
        ArrayList<FlowEntry> outputFlows = new ArrayList<FlowEntry>();
        ArrayList<Instruction> deferredInstructions = new ArrayList<Instruction>();
        PipelineTraceableHitChain currentHitChain = PipelineTraceableHitChain.emptyHitChain();
        TrafficSelector currentPacket = DefaultTrafficSelector.builder((TrafficSelector)input.ingressPacket().packet()).build();
        int initialTableId = -1;
        FlowEntry nextTableIdEntry = this.findNextTableIdEntry(initialTableId, input.flows());
        if (nextTableIdEntry == null) {
            currentHitChain.setEgressPacket(new PipelineTraceablePacket(currentPacket));
            currentHitChain.dropped();
            return outputBuilder.appendToLog("No flow rules for device " + this.deviceId + ". Aborting").noFlows().addHitChain(currentHitChain).build();
        }
        TableId tableId = nextTableIdEntry.table();
        boolean lastTable = false;
        while (!lastTable) {
            log.debug("Searching a Flow Entry on table {} for packet {}", (Object)tableId, (Object)currentPacket);
            flowEntry = this.matchHighestPriority(currentPacket, tableId, input.flows());
            log.debug("Found Flow Entry {}", (Object)flowEntry);
            if (flowEntry == null && this.isHardwareSwitch()) {
                log.debug("Ofdpa Hw setup, no flow rule means table miss");
                if ((Integer)((IndexTableId)tableId).id() == 27) {
                    currentPacket = this.handleOfdpa27FixedTable(input.ingressPacket().packet(), currentPacket);
                    tableId = IndexTableId.of((int)59);
                }
                nextTableIdEntry = this.findNextTableIdEntry((Integer)((IndexTableId)tableId).id(), input.flows());
                log.debug("Next table id entry {}", (Object)nextTableIdEntry);
                if (nextTableIdEntry == null && currentHitChain.hitChain().size() == 0) {
                    currentHitChain.setEgressPacket(new PipelineTraceablePacket(currentPacket));
                    currentHitChain.dropped();
                    return outputBuilder.appendToLog("No flow rules for device " + this.deviceId + ". Aborting").noFlows().addHitChain(currentHitChain).build();
                }
                if (nextTableIdEntry == null) {
                    lastTable = true;
                    continue;
                }
                if ((Integer)((IndexTableId)tableId).id() == 20) {
                    log.debug("A miss on Table 20 on OFDPA means that we skip directly to table 50");
                    tableId = IndexTableId.of((int)50);
                    continue;
                }
                if ((Integer)((IndexTableId)tableId).id() == 40) {
                    log.debug("A miss on Table 40 on OFDPA means that we skip directly to table 60");
                    tableId = IndexTableId.of((int)60);
                    continue;
                }
                tableId = nextTableIdEntry.table();
                continue;
            }
            if (flowEntry == null) {
                currentHitChain.setEgressPacket(new PipelineTraceablePacket(currentPacket));
                currentHitChain.dropped();
                return outputBuilder.appendToLog("Packet has no match on table " + tableId + " in device " + this.deviceId + ". Dropping").noFlows().addHitChain(currentHitChain).build();
            }
            if (flowEntry.treatment().tableTransition() != null) {
                tableId = IndexTableId.of((int)flowEntry.treatment().tableTransition().tableId());
                log.debug("Flow Entry has transition to table Id {}", (Object)tableId);
                currentHitChain.addDataPlaneEntity(new DataPlaneEntity(flowEntry));
            } else {
                log.debug("Flow Entry has no transition to table, treating as last rule {}", (Object)flowEntry);
                currentHitChain.addDataPlaneEntity(new DataPlaneEntity(flowEntry));
                outputFlows.add(flowEntry);
                lastTable = true;
            }
            currentPacket = this.updatePacket(currentPacket, flowEntry.treatment().immediate()).build();
            deferredInstructions.addAll(flowEntry.treatment().deferred());
            if (flowEntry.treatment().clearedDeferred()) {
                deferredInstructions.clear();
            }
            if (!this.shouldMatchSecondVlanFlow(flowEntry)) continue;
            VlanIdCriterion packetVlanIdCriterion = (VlanIdCriterion)currentPacket.getCriterion(Criterion.Type.VLAN_VID);
            L2ModificationInstruction.ModVlanIdInstruction entryModVlanIdInstruction = flowEntry.treatment().immediate().stream().filter(instruction -> instruction instanceof L2ModificationInstruction.ModVlanIdInstruction).findFirst().orElse(null);
            if (entryModVlanIdInstruction == null) continue;
            FlowEntry secondVlanFlow = this.getSecondFlowEntryOnTable10(currentPacket, packetVlanIdCriterion, entryModVlanIdInstruction, input.flows());
            if (secondVlanFlow != null) {
                currentHitChain.addDataPlaneEntity(new DataPlaneEntity(secondVlanFlow));
                continue;
            }
            currentHitChain.setEgressPacket(new PipelineTraceablePacket(currentPacket));
            currentHitChain.dropped();
            return outputBuilder.appendToLog("Missing forwarding rule for tagged packet on " + this.deviceId).noFlows().addHitChain(currentHitChain).build();
        }
        TrafficSelector.Builder egressPacket = DefaultTrafficSelector.builder((TrafficSelector)currentPacket);
        log.debug("Current packet {} - applying output flows", (Object)currentPacket);
        ArrayList<PortNumber> outputPorts = new ArrayList<PortNumber>();
        this.handleOutputFlows(currentPacket, outputFlows, egressPacket, outputPorts, currentHitChain, outputBuilder, input.ingressPacket().packet());
        log.debug("Current packet {} - applying immediate instructions", (Object)currentPacket);
        ImmutableList entries = ImmutableList.copyOf((Collection)currentHitChain.hitChain());
        PipelineTraceableHitChain newHitChain = PipelineTraceableHitChain.emptyHitChain();
        currentHitChain.hitChain().forEach(arg_0 -> ((PipelineTraceableHitChain)newHitChain).addDataPlaneEntity(arg_0));
        TrafficSelector.Builder newEgressPacket = DefaultTrafficSelector.builder((TrafficSelector)egressPacket.build());
        for (DataPlaneEntity entry : entries) {
            flowEntry = entry.getFlowEntry();
            if (flowEntry == null) continue;
            this.getGroupsFromInstructions(input.groups(), flowEntry.treatment().immediate(), newEgressPacket, outputPorts, newHitChain, outputBuilder, input, false);
        }
        log.debug("Current packet {} - applying deferred instructions", (Object)egressPacket.build());
        if (deferredInstructions.size() > 0) {
            this.handleDeferredActions(egressPacket.build(), input.groups(), deferredInstructions, outputPorts, currentHitChain, outputBuilder, input);
        }
        if (outputPorts.isEmpty()) {
            currentHitChain.setEgressPacket(new PipelineTraceablePacket(egressPacket.build()));
            currentHitChain.dropped();
            outputBuilder.appendToLog("Packet has no output in device " + this.deviceId + ". Dropping").dropped().addHitChain(currentHitChain);
        }
        return outputBuilder.build();
    }

    private FlowEntry findNextTableIdEntry(int currentId, List<FlowEntry> flows) {
        return flows.stream().filter(f -> (Integer)((IndexTableId)f.table()).id() > currentId).min(this.comparatorById).orElse(null);
    }

    private FlowEntry matchHighestPriority(TrafficSelector packet, TableId tableId, List<FlowEntry> flows) {
        return flows.stream().filter(flowEntry -> flowEntry.table().equals(tableId)).filter(flowEntry -> this.match(packet, (FlowEntry)flowEntry)).max(this.comparatorByPriority).orElse(null);
    }

    private boolean match(TrafficSelector packet, FlowEntry flowEntry) {
        return flowEntry.selector().criteria().stream().allMatch(criterion -> {
            Criterion.Type type = criterion.type();
            if (type.equals((Object)Criterion.Type.IPV4_SRC) || type.equals((Object)Criterion.Type.IPV4_DST) || type.equals((Object)Criterion.Type.IPV6_SRC) || type.equals((Object)Criterion.Type.IPV6_DST)) {
                return this.matchIp(packet, (IPCriterion)criterion);
            }
            if (type.equals((Object)Criterion.Type.ETH_SRC_MASKED)) {
                return this.matchMac(packet, (EthCriterion)criterion, false);
            }
            if (type.equals((Object)Criterion.Type.ETH_DST_MASKED)) {
                return this.matchMac(packet, (EthCriterion)criterion, true);
            }
            return packet.criteria().contains(criterion);
        });
    }

    private boolean matchIp(TrafficSelector packet, IPCriterion criterion) {
        IPCriterion matchCriterion = (IPCriterion)packet.getCriterion(criterion.type());
        if (matchCriterion == null) {
            return false;
        }
        log.debug("Checking if {} is under {}", (Object)matchCriterion.ip(), (Object)criterion.ip());
        IpPrefix subnet = criterion.ip();
        return subnet.contains(matchCriterion.ip().address());
    }

    private boolean matchMac(TrafficSelector packet, EthCriterion hitCriterion, boolean dst) {
        EthCriterion matchCriterion = dst ? (EthCriterion)packet.criteria().stream().filter(criterion1 -> criterion1.type().equals((Object)Criterion.Type.ETH_DST_MASKED) || criterion1.type().equals((Object)Criterion.Type.ETH_DST)).findFirst().orElse(null) : (EthCriterion)packet.criteria().stream().filter(criterion1 -> criterion1.type().equals((Object)Criterion.Type.ETH_SRC_MASKED) || criterion1.type().equals((Object)Criterion.Type.ETH_SRC)).findFirst().orElse(null);
        if (matchCriterion == null) {
            return true;
        }
        log.debug("Checking if {} is under {}/{}", new Object[]{matchCriterion.mac(), hitCriterion.mac(), hitCriterion.mask()});
        return matchCriterion.mac().inRange(hitCriterion.mac(), hitCriterion.mask());
    }

    private TrafficSelector handleOfdpa27FixedTable(TrafficSelector initialPacket, TrafficSelector packet) {
        log.debug("Handling table 27 on OFDPA, removing mpls ETH Type and change mpls label");
        Criterion mplsCriterion = packet.getCriterion(Criterion.Type.ETH_TYPE);
        Criterion metadataCriterion = initialPacket.getCriterion(Criterion.Type.METADATA);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (mplsCriterion != null && ((EthTypeCriterion)mplsCriterion).ethType().equals((Object)EthType.EtherType.MPLS_UNICAST.ethType()) && metadataCriterion != null) {
            long ethType = ((MetadataCriterion)metadataCriterion).metadata();
            Instruction ethInstruction = Instructions.popMpls((EthType)EthType.EtherType.lookup((short)((short)ethType)).ethType());
            builder.add((Object)ethInstruction);
            TrafficSelector.Builder currentPacketBuilder = DefaultTrafficSelector.builder();
            packet.criteria().stream().filter(criterion -> criterion.type() != Criterion.Type.METADATA).forEach(arg_0 -> ((TrafficSelector.Builder)currentPacketBuilder).add(arg_0));
            packet = currentPacketBuilder.build();
        }
        packet = this.updatePacket(packet, (List<Instruction>)builder.build()).build();
        return packet;
    }

    private TrafficSelector.Builder updatePacket(TrafficSelector packet, List<Instruction> instructions) {
        TrafficSelector.Builder newSelector = DefaultTrafficSelector.builder((TrafficSelector)packet);
        for (Instruction instruction : instructions) {
            newSelector = this.translateInstruction(newSelector, instruction);
        }
        return newSelector;
    }

    private TrafficSelector.Builder translateInstruction(TrafficSelector.Builder newSelector, Instruction instruction) {
        Criterion criterion;
        block13: {
            block12: {
                log.debug("Translating instruction {}", (Object)instruction);
                log.debug("New Selector {}", (Object)newSelector.build());
                criterion = null;
                if (instruction.type() != Instruction.Type.L2MODIFICATION) break block12;
                L2ModificationInstruction l2Instruction = (L2ModificationInstruction)instruction;
                switch (l2Instruction.subtype()) {
                    case VLAN_ID: {
                        L2ModificationInstruction.ModVlanIdInstruction vlanIdInstruction = (L2ModificationInstruction.ModVlanIdInstruction)instruction;
                        VlanId id = vlanIdInstruction.vlanId();
                        criterion = Criteria.matchVlanId((VlanId)id);
                        break;
                    }
                    case VLAN_POP: {
                        criterion = Criteria.matchVlanId((VlanId)VlanId.NONE);
                        break;
                    }
                    case MPLS_PUSH: {
                        TrafficSelector temporaryPacket;
                        Criterion ethCriterion;
                        L2ModificationInstruction.ModMplsHeaderInstruction mplsEthInstruction = (L2ModificationInstruction.ModMplsHeaderInstruction)instruction;
                        criterion = Criteria.matchEthType((int)mplsEthInstruction.ethernetType().toShort());
                        if (this.isHardwareSwitch() && (ethCriterion = (temporaryPacket = newSelector.build()).getCriterion(Criterion.Type.ETH_TYPE)) != null) {
                            TrafficSelector.Builder tempSelector = DefaultTrafficSelector.builder((TrafficSelector)temporaryPacket);
                            tempSelector.matchMetadata((long)((EthTypeCriterion)ethCriterion).ethType().toShort());
                            newSelector = tempSelector;
                            break;
                        }
                        break block13;
                    }
                    case MPLS_POP: {
                        L2ModificationInstruction.ModMplsHeaderInstruction mplsPopInstruction = (L2ModificationInstruction.ModMplsHeaderInstruction)instruction;
                        criterion = Criteria.matchEthType((int)mplsPopInstruction.ethernetType().toShort());
                        TrafficSelector temporaryPacket = newSelector.build();
                        if (temporaryPacket.getCriterion(Criterion.Type.MPLS_LABEL) != null) {
                            TrafficSelector.Builder noMplsSelector = DefaultTrafficSelector.builder();
                            temporaryPacket.criteria().stream().filter(c -> !c.type().equals((Object)Criterion.Type.MPLS_LABEL) && !c.type().equals((Object)Criterion.Type.MPLS_BOS)).forEach(arg_0 -> ((TrafficSelector.Builder)noMplsSelector).add(arg_0));
                            newSelector = noMplsSelector;
                            break;
                        }
                        break block13;
                    }
                    case MPLS_LABEL: {
                        L2ModificationInstruction.ModMplsLabelInstruction mplsLabelInstruction = (L2ModificationInstruction.ModMplsLabelInstruction)instruction;
                        criterion = Criteria.matchMplsLabel((MplsLabel)mplsLabelInstruction.label());
                        newSelector.matchMplsBos(true);
                        break;
                    }
                    case ETH_DST: {
                        L2ModificationInstruction.ModEtherInstruction modEtherDstInstruction = (L2ModificationInstruction.ModEtherInstruction)instruction;
                        criterion = Criteria.matchEthDst((MacAddress)modEtherDstInstruction.mac());
                        break;
                    }
                    case ETH_SRC: {
                        L2ModificationInstruction.ModEtherInstruction modEtherSrcInstruction = (L2ModificationInstruction.ModEtherInstruction)instruction;
                        criterion = Criteria.matchEthSrc((MacAddress)modEtherSrcInstruction.mac());
                        break;
                    }
                    default: {
                        log.debug("Unsupported L2 Instruction");
                    }
                }
                break block13;
            }
            log.debug("Unsupported Instruction");
        }
        if (criterion != null) {
            log.debug("Adding criterion {}", criterion);
            newSelector.add(criterion);
        }
        return newSelector;
    }

    private FlowEntry getSecondFlowEntryOnTable10(TrafficSelector packet, VlanIdCriterion packetVlanIdCriterion, L2ModificationInstruction.ModVlanIdInstruction entryModVlanIdInstruction, List<FlowEntry> flows) {
        FlowEntry secondVlanFlow = null;
        if (packetVlanIdCriterion.vlanId().equals((Object)entryModVlanIdInstruction.vlanId())) {
            secondVlanFlow = flows.stream().filter(entry -> entry.table().equals(IndexTableId.of((int)10))).filter(entry -> {
                VlanIdCriterion criterion = (VlanIdCriterion)entry.selector().getCriterion(Criterion.Type.VLAN_VID);
                return criterion != null && this.match(packet, (FlowEntry)entry) && criterion.vlanId().equals((Object)entryModVlanIdInstruction.vlanId());
            }).findFirst().orElse(null);
        }
        return secondVlanFlow;
    }

    private List<FlowEntry> handleOutputFlows(TrafficSelector currentPacket, List<FlowEntry> outputFlows, TrafficSelector.Builder egressPacket, List<PortNumber> outputPorts, PipelineTraceableHitChain currentHitChain, PipelineTraceableOutput.Builder outputBuilder, TrafficSelector initialPacket) {
        List<FlowEntry> outputFlowEntries = outputFlows.stream().filter(flow -> flow.treatment().allInstructions().stream().filter(instruction -> instruction.type().equals((Object)Instruction.Type.OUTPUT)).count() > 0L).collect(Collectors.toList());
        if (outputFlowEntries.size() > 1) {
            outputBuilder.appendToLog("More than one flow rule with OUTPUT instruction");
            log.warn("There cannot be more than one flow entry with OUTPUT instruction for {}", (Object)currentPacket);
        }
        if (outputFlowEntries.size() == 1) {
            Instructions.OutputInstruction outputInstruction = (Instructions.OutputInstruction)outputFlowEntries.get(0).treatment().allInstructions().stream().filter(instruction -> instruction.type().equals((Object)Instruction.Type.OUTPUT)).findFirst().get();
            this.buildOutputFromDevice(egressPacket, outputPorts, outputInstruction, currentHitChain, outputBuilder, initialPacket, false);
        }
        return outputFlowEntries;
    }

    private void buildOutputFromDevice(TrafficSelector.Builder egressPacket, List<PortNumber> outputPorts, Instructions.OutputInstruction outputInstruction, PipelineTraceableHitChain currentHitChain, PipelineTraceableOutput.Builder outputBuilder, TrafficSelector initialPacket, boolean dropped) {
        outputPorts.add(outputInstruction.port());
        ConnectPoint outputPort = new ConnectPoint((ElementId)this.deviceId, outputInstruction.port());
        PipelineTraceableHitChain finalHitChain = new PipelineTraceableHitChain(outputPort, (List)Lists.newArrayList((Iterable)currentHitChain.hitChain()), new PipelineTraceablePacket(egressPacket.build()));
        if (dropped) {
            log.debug("Packet {} has been dropped", (Object)egressPacket.build());
        } else {
            finalHitChain.pass();
        }
        if (outputPort.port().equals((Object)PortNumber.CONTROLLER)) {
            this.handleVlanToController(finalHitChain, initialPacket);
        }
        outputBuilder.addHitChain(finalHitChain);
    }

    private void handleVlanToController(PipelineTraceableHitChain currentHitChain, TrafficSelector initialPacket) {
        VlanIdCriterion initialVid = (VlanIdCriterion)initialPacket.getCriterion(Criterion.Type.VLAN_VID);
        VlanIdCriterion finalVid = (VlanIdCriterion)currentHitChain.egressPacket().packet().getCriterion(Criterion.Type.VLAN_VID);
        if (initialVid != null && !initialVid.equals((Object)finalVid) && initialVid.vlanId().equals((Object)VlanId.NONE)) {
            HashSet finalCriteria = new HashSet(currentHitChain.egressPacket().packet().criteria());
            finalCriteria.remove(finalVid);
            TrafficSelector.Builder packetUpdated = DefaultTrafficSelector.builder();
            finalCriteria.forEach(arg_0 -> ((TrafficSelector.Builder)packetUpdated).add(arg_0));
            packetUpdated.add(Criteria.matchVlanId((VlanId)VlanId.NONE));
            currentHitChain.setEgressPacket(new PipelineTraceablePacket(packetUpdated.build()));
        }
    }

    private void getGroupsFromInstructions(Map<GroupId, Group> groups, List<Instruction> instructions, TrafficSelector.Builder egressPacket, List<PortNumber> outputPorts, PipelineTraceableHitChain currentHitChain, PipelineTraceableOutput.Builder outputBuilder, PipelineTraceableInput input, boolean dropped) {
        ArrayList<Instruction> groupInstructionlist = new ArrayList<Instruction>();
        ArrayList<Instruction> instructionsSorted = new ArrayList<Instruction>();
        instructionsSorted.addAll(instructions);
        instructionsSorted.sort((instr1, instr2) -> Integer.compare(instr2.type().ordinal(), instr1.type().ordinal()));
        for (Instruction instruction : instructionsSorted) {
            log.debug("Considering Instruction {}", (Object)instruction);
            if (!instruction.type().equals((Object)Instruction.Type.GROUP)) {
                if (instruction.type().equals((Object)Instruction.Type.OUTPUT)) {
                    this.buildOutputFromDevice(egressPacket, outputPorts, (Instructions.OutputInstruction)instruction, currentHitChain, outputBuilder, input.ingressPacket().packet(), dropped);
                    continue;
                }
                egressPacket = this.translateInstruction(egressPacket, instruction);
                continue;
            }
            groupInstructionlist.add(instruction);
        }
        for (Instruction instr : groupInstructionlist) {
            Instructions.GroupInstruction groupInstruction = (Instructions.GroupInstruction)instr;
            Group group = groups.get(groupInstruction.groupId());
            if (group == null) {
                currentHitChain.setEgressPacket(new PipelineTraceablePacket(egressPacket.build()));
                currentHitChain.dropped();
                outputBuilder.appendToLog("Null group for Instruction " + instr).noGroups().addHitChain(currentHitChain);
                break;
            }
            log.debug("Analyzing group {}", (Object)group.id());
            if (group.buckets().buckets().size() == 0) {
                currentHitChain.addDataPlaneEntity(new DataPlaneEntity(group));
                currentHitChain.setEgressPacket(new PipelineTraceablePacket(egressPacket.build()));
                currentHitChain.dropped();
                outputBuilder.appendToLog("Group " + group.id() + " has no buckets").noMembers().addHitChain(currentHitChain);
                break;
            }
            for (GroupBucket bucket : group.buckets().buckets()) {
                currentHitChain.addDataPlaneEntity(new DataPlaneEntity(group));
                PipelineTraceableHitChain newHitChain = PipelineTraceableHitChain.emptyHitChain();
                currentHitChain.hitChain().forEach(arg_0 -> ((PipelineTraceableHitChain)newHitChain).addDataPlaneEntity(arg_0));
                TrafficSelector.Builder newEgressPacket = DefaultTrafficSelector.builder((TrafficSelector)egressPacket.build());
                this.getGroupsFromInstructions(groups, bucket.treatment().allInstructions(), newEgressPacket, outputPorts, newHitChain, outputBuilder, input, dropped | this.isDropped(group.id(), bucket, input.ingressPort()));
            }
        }
    }

    private boolean isDropped(GroupId groupId, GroupBucket bucket, ConnectPoint ingressPort) {
        log.debug("Verify if the packet has to be dropped by the input port {}", (Object)ingressPort);
        int maskedId = (Integer)groupId.id() & 0xF0000000;
        if (maskedId != 0x40000000 && maskedId != 0x30000000 && maskedId != 0x60000000) {
            return false;
        }
        for (Instruction instr : bucket.treatment().allInstructions()) {
            Instructions.GroupInstruction groupInstruction;
            if (!instr.type().equals((Object)Instruction.Type.GROUP) || ((Integer)(groupInstruction = (Instructions.GroupInstruction)instr).groupId().id() & 0xF0000000) != 0) continue;
            return (long)((Integer)groupInstruction.groupId().id() & 0xFFFF) == ingressPort.port().toLong();
        }
        return false;
    }

    private void handleDeferredActions(TrafficSelector egressPacket, Map<GroupId, Group> groups, List<Instruction> deferredInstructions, List<PortNumber> outputPorts, PipelineTraceableHitChain currentHitChain, PipelineTraceableOutput.Builder outputBuilder, PipelineTraceableInput input) {
        TrafficSelector.Builder newEgressPacket = this.updatePacket(egressPacket, deferredInstructions);
        List outputFlowInstruction = deferredInstructions.stream().filter(instruction -> instruction.type().equals((Object)Instruction.Type.OUTPUT)).collect(Collectors.toList());
        if (outputFlowInstruction.size() > 1) {
            outputBuilder.appendToLog("More than one flow rule with OUTPUT instruction");
            log.warn("There cannot be more than one flow entry with OUTPUT instruction for {}", (Object)egressPacket);
        }
        if (outputFlowInstruction.size() == 1) {
            this.buildOutputFromDevice(newEgressPacket, outputPorts, (Instructions.OutputInstruction)outputFlowInstruction.get(0), currentHitChain, outputBuilder, input.ingressPacket().packet(), false);
        }
        if (outputFlowInstruction.size() == 0) {
            this.getGroupsFromInstructions(groups, deferredInstructions, newEgressPacket, outputPorts, currentHitChain, outputBuilder, input, false);
        }
    }

    private boolean isHardwareSwitch() {
        if (!this.handler().hasBehaviour(Pipeliner.class)) {
            throw new UnsupportedOperationException("Not supported device");
        }
        Pipeliner pipeliner = (Pipeliner)this.handler().behaviour(Pipeliner.class);
        if (pipeliner instanceof OvsOfdpaPipeline) {
            return false;
        }
        if (pipeliner instanceof Ofdpa2Pipeline) {
            return true;
        }
        throw new UnsupportedOperationException("Not supported device");
    }

    private boolean shouldMatchSecondVlanFlow(FlowEntry flowEntry) {
        if (!this.handler().hasBehaviour(Pipeliner.class)) {
            throw new UnsupportedOperationException("Not supported device");
        }
        Pipeliner pipeliner = (Pipeliner)this.handler().behaviour(Pipeliner.class);
        if (!(pipeliner instanceof Ofdpa2Pipeline)) {
            return false;
        }
        return ((Ofdpa2Pipeline)pipeliner).requireSecondVlanTableEntry() && flowEntry.table().equals(IndexTableId.of((int)10)) && flowEntry.selector().getCriterion(Criterion.Type.VLAN_VID) != null && ((VlanIdCriterion)flowEntry.selector().getCriterion(Criterion.Type.VLAN_VID)).vlanId().equals((Object)VlanId.NONE);
    }
}

