/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.behaviour.PortDiscovery;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortGetterFujitsuImpl
extends AbstractHandlerBehaviour
implements PortDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public List<PortDescription> getPorts() {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.get(this.requestBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve configuration.", (Throwable)e));
        }
        List descriptions = XmlConfigParser.parseFujitsuT100Ports((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes())));
        return descriptions;
    }

    private String requestBuilder() {
        StringBuilder rpc = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter type=\"subtree\">");
        rpc.append("<interfaces xmlns=\"urn:ietf:params:xml:ns:yang:ietf-interfaces\">");
        rpc.append("</interfaces>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>");
        return rpc.toString();
    }
}

