/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;

public class LsaHeaderTest {
    private LsaHeader lsaHeader;
    private int result;
    private Ip4Address result1;
    private long result2;
    private OspfLsaType ospflsaType;
    private LsaHeader header;
    private byte[] result3;
    private LsaHeader lsaHeader1;
    private String result4;

    @Before
    public void setUp() throws Exception {
        this.lsaHeader = new LsaHeader();
    }

    @After
    public void tearDown() throws Exception {
        this.lsaHeader = null;
        this.result1 = null;
        this.ospflsaType = null;
        this.header = null;
        this.result3 = null;
        this.lsaHeader1 = null;
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaHeader.equals((Object)new LsaHeader()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        this.result = this.lsaHeader.hashCode();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetAge() throws Exception {
        this.lsaHeader.setAge(10);
        this.result = this.lsaHeader.age();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetAge() throws Exception {
        this.lsaHeader.setAge(10);
        this.result = this.lsaHeader.age();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testGetOptions() throws Exception {
        this.lsaHeader.setOptions(2);
        this.result = this.lsaHeader.options();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSetOptions() throws Exception {
        this.lsaHeader.setOptions(2);
        this.result = this.lsaHeader.options();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetLsType() throws Exception {
        this.lsaHeader.setLsType(1);
        this.result = this.lsaHeader.lsType();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetLsType() throws Exception {
        this.lsaHeader.setLsType(1);
        this.result = this.lsaHeader.lsType();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetLinkStateId() throws Exception {
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.result4 = this.lsaHeader.linkStateId();
        MatcherAssert.assertThat((Object)this.result4, (Matcher)Matchers.is((Object)"10.226.165.164"));
    }

    @Test
    public void testSetLinkStateId() throws Exception {
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.result4 = this.lsaHeader.linkStateId();
        MatcherAssert.assertThat((Object)this.result4, (Matcher)Matchers.is((Object)"10.226.165.164"));
    }

    @Test
    public void testGetAdvertisingRouter() throws Exception {
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result1 = this.lsaHeader.advertisingRouter();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetAdvertisingRouter() throws Exception {
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result1 = this.lsaHeader.advertisingRouter();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testGetLsSequenceNo() throws Exception {
        this.lsaHeader.setLsSequenceNo(222L);
        this.result2 = this.lsaHeader.lsSequenceNo();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)222L));
    }

    @Test
    public void testSetLsSequenceNo() throws Exception {
        this.lsaHeader.setLsSequenceNo(222L);
        this.result2 = this.lsaHeader.lsSequenceNo();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Object)222L));
    }

    @Test
    public void testGetLsChecksum() throws Exception {
        this.lsaHeader.setLsCheckSum(2);
        this.result = this.lsaHeader.lsCheckSum();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSetLsChecksum() throws Exception {
        this.lsaHeader.setLsCheckSum(2);
        this.result = this.lsaHeader.lsCheckSum();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetLsPacketLen() throws Exception {
        this.lsaHeader.setLsPacketLen(48);
        this.result = this.lsaHeader.lsPacketLen();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)48));
    }

    @Test
    public void testSetLsPacketLen() throws Exception {
        this.lsaHeader.setLsPacketLen(48);
        this.result = this.lsaHeader.lsPacketLen();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)48));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.lsaHeader.setLsType(1);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.ROUTER));
        this.lsaHeader.setLsType(2);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.NETWORK));
        this.lsaHeader.setLsType(3);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.SUMMARY));
        this.lsaHeader.setLsType(4);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.ASBR_SUMMARY));
        this.lsaHeader.setLsType(5);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.EXTERNAL_LSA));
        this.lsaHeader.setLsType(6);
        this.ospflsaType = this.lsaHeader.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.UNDEFINED));
    }

    @Test
    public void testGetLsaHeader() throws Exception {
        this.header = (LsaHeader)this.lsaHeader.lsaHeader();
        MatcherAssert.assertThat((Object)this.header, (Matcher)Matchers.instanceOf(LsaHeader.class));
    }

    @Test
    public void testGetLsaHeaderAsByteArray() throws Exception {
        this.result3 = this.lsaHeader.getLsaHeaderAsByteArray();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaHeader.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPopulateHeader() throws Exception {
        this.lsaHeader1 = new LsaHeader();
        this.lsaHeader1.setLsPacketLen(10);
        this.lsaHeader1.setAdvertisingRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsaHeader1.setOptions(2);
        this.lsaHeader1.setAge(20);
        this.lsaHeader1.setLsType(3);
        this.lsaHeader1.setLinkStateId("2.2.2.2");
        this.lsaHeader1.setLsCheckSum(1234);
        this.lsaHeader1.setLsSequenceNo(456789L);
        this.lsaHeader.populateHeader(this.lsaHeader1);
        MatcherAssert.assertThat((Object)this.lsaHeader1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

