/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.LinkId;

public class LinkIdTest {
    private final byte[] packet = new byte[]{1, 1, 1, 1};
    private final byte[] packet1 = new byte[]{0, 0, 1};
    private LinkId linkId;
    private TlvHeader tlvHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.linkId = new LinkId(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.linkId = null;
        this.channelBuffer = null;
        this.tlvHeader = null;
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.linkId.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkId() throws Exception {
        this.linkId.setLinkId("1.1.1.1");
        MatcherAssert.assertThat((Object)this.linkId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetLinkId() throws Exception {
        this.linkId.setLinkId("1.1.1.1");
        MatcherAssert.assertThat((Object)this.linkId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(2);
        this.tlvHeader.setTlvLength(4);
        this.linkId = new LinkId(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.linkId.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.linkId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(2);
        this.tlvHeader.setTlvLength(4);
        this.linkId = new LinkId(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.linkId.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.linkId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.linkId.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.linkId.getLinkSubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

