/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.LocalInterfaceIpAddress;

public class LocalInterfaceIpAddressTest {
    private final byte[] packet = new byte[]{1, 1, 1, 1};
    private final byte[] packet1 = new byte[0];
    private LocalInterfaceIpAddress localInterfaceIpAddress;
    private TlvHeader tlvHeader;
    private byte[] result;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.localInterfaceIpAddress = new LocalInterfaceIpAddress(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.localInterfaceIpAddress = null;
        this.tlvHeader = null;
        this.result = null;
        this.channelBuffer = null;
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.localInterfaceIpAddress.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddLocalInterfaceIPAddress() throws Exception {
        this.localInterfaceIpAddress.addLocalInterfaceIPAddress("1.1.1.1");
        MatcherAssert.assertThat((Object)this.localInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(3);
        this.tlvHeader.setTlvLength(4);
        this.localInterfaceIpAddress = new LocalInterfaceIpAddress(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.localInterfaceIpAddress.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.localInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom1() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(3);
        this.tlvHeader.setTlvLength(4);
        this.localInterfaceIpAddress = new LocalInterfaceIpAddress(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.localInterfaceIpAddress.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.localInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.localInterfaceIpAddress.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.localInterfaceIpAddress.getLinkSubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

