/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.MaximumBandwidth;

public class MaximumBandwidthTest {
    private final byte[] packet = new byte[]{0, 0, 0, 0};
    private MaximumBandwidth maximumBandwidth;
    private TlvHeader header;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.maximumBandwidth = new MaximumBandwidth(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.maximumBandwidth = null;
        this.header = null;
        this.channelBuffer = null;
        this.result = null;
    }

    @Test
    public void testSetMaximumBandwidth() throws Exception {
        this.maximumBandwidth.setMaximumBandwidth(123456.0f);
        MatcherAssert.assertThat((Object)this.maximumBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvType(6);
        this.header.setTlvLength(4);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.maximumBandwidth = new MaximumBandwidth(this.header);
        this.maximumBandwidth.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.maximumBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.maximumBandwidth.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.maximumBandwidth.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

