/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.MaximumReservableBandwidth;

public class MaximumReservableBandwidthTest {
    private final byte[] packet = new byte[]{0, 0, 0, 0};
    private MaximumReservableBandwidth maximumReservableBandwidth;
    private TlvHeader header;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.maximumReservableBandwidth = new MaximumReservableBandwidth(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.maximumReservableBandwidth = null;
        this.header = null;
        this.channelBuffer = null;
        this.result = null;
    }

    @Test
    public void testSetMaximumBandwidth() throws Exception {
        this.maximumReservableBandwidth.setMaximumBandwidth(123456.78f);
        MatcherAssert.assertThat((Object)this.maximumReservableBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvType(6);
        this.header.setTlvLength(4);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.maximumReservableBandwidth = new MaximumReservableBandwidth(this.header);
        this.maximumReservableBandwidth.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.maximumReservableBandwidth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.maximumReservableBandwidth.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.maximumReservableBandwidth.getLinksubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.maximumReservableBandwidth.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

