/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.RemoteInterfaceIpAddress;

public class RemoteInterfaceIpAddressTest {
    private final byte[] packet = new byte[]{1, 1, 1, 1};
    private final byte[] packet1 = new byte[0];
    private byte[] result;
    private TlvHeader tlvHeader;
    private RemoteInterfaceIpAddress remoteInterfaceIpAddress;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.remoteInterfaceIpAddress = new RemoteInterfaceIpAddress(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.remoteInterfaceIpAddress = null;
        this.result = null;
        this.tlvHeader = null;
        this.channelBuffer = null;
    }

    @Test
    public void testAddRemoteInterfaceIpAddress() throws Exception {
        this.remoteInterfaceIpAddress.addRemoteInterfaceAddress("1.1.1.1");
        MatcherAssert.assertThat((Object)this.remoteInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(4);
        this.tlvHeader.setTlvLength(4);
        this.remoteInterfaceIpAddress = new RemoteInterfaceIpAddress(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.remoteInterfaceIpAddress.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.remoteInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom1() throws Exception {
        this.tlvHeader = new TlvHeader();
        this.tlvHeader.setTlvType(4);
        this.tlvHeader.setTlvLength(4);
        this.remoteInterfaceIpAddress = new RemoteInterfaceIpAddress(this.tlvHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.remoteInterfaceIpAddress.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.remoteInterfaceIpAddress, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.remoteInterfaceIpAddress.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.remoteInterfaceIpAddress.getLinkSubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.remoteInterfaceIpAddress.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

