/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.TrafficEngineeringMetric;

public class TrafficEngineeringMetricTest {
    private final byte[] packet = new byte[]{0, 0, 1, 1};
    private TrafficEngineeringMetric trafficEngineeringMetric;
    private TlvHeader header;
    private byte[] result;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.trafficEngineeringMetric = new TrafficEngineeringMetric(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.trafficEngineeringMetric = null;
        this.header = null;
        this.result = null;
        this.channelBuffer = null;
    }

    @Test
    public void testSetTrafficEngineeringMetric() throws Exception {
        this.trafficEngineeringMetric.setTrafficEngineeringMetric(123456789L);
        MatcherAssert.assertThat((Object)this.trafficEngineeringMetric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvLength(4);
        this.header.setTlvType(5);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.trafficEngineeringMetric = new TrafficEngineeringMetric(this.header);
        this.trafficEngineeringMetric.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.trafficEngineeringMetric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.trafficEngineeringMetric.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.result = this.trafficEngineeringMetric.getLinkSubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.trafficEngineeringMetric.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

