/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.linksubtype;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.linksubtype.UnknownLinkSubType;

public class UnknownLinkSubTypeTest {
    private final byte[] packet = new byte[]{0, 114, 0, 4, 0, 0, 0, 1};
    private UnknownLinkSubType unknownLinkSubType;
    private TlvHeader header;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.unknownLinkSubType = new UnknownLinkSubType(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.unknownLinkSubType = null;
        this.header = null;
    }

    @Test
    public void testValue() throws Exception {
        this.unknownLinkSubType.setValue(this.packet);
        MatcherAssert.assertThat((Object)this.unknownLinkSubType.value(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetValue() throws Exception {
        this.unknownLinkSubType.setValue(this.packet);
        MatcherAssert.assertThat((Object)this.unknownLinkSubType.value(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvLength(8);
        this.header.setTlvType(114);
        this.unknownLinkSubType = new UnknownLinkSubType(this.header);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.unknownLinkSubType.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.unknownLinkSubType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testAsBytes() throws Exception {
        this.result = this.unknownLinkSubType.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLinkSubTypeTlvBodyAsByteArray() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.unknownLinkSubType.readFrom(this.channelBuffer);
        this.result = this.unknownLinkSubType.getLinkSubTypeTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.unknownLinkSubType.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

