/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.tlvtypes;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.tlvtypes.RouterTlv;

public class RouterTlvTest {
    private final byte[] packet = new byte[]{1, 1, 1, 1};
    private final byte[] packet1 = new byte[]{1, 1, 1};
    private RouterTlv rtlv;
    private TlvHeader header;
    private ChannelBuffer channelBuffer;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.rtlv = new RouterTlv(new TlvHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.rtlv = null;
        this.header = null;
        this.channelBuffer = null;
        this.result = null;
    }

    @Test
    public void testGetRouterAddress() throws Exception {
        this.rtlv.setRouterAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.rtlv.routerAddress(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetRouterAddress() throws Exception {
        this.rtlv.setRouterAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.rtlv.routerAddress(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvType(1);
        this.header.setTlvLength(4);
        this.rtlv = new RouterTlv(this.header);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.rtlv.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.rtlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.rtlv, (Matcher)Matchers.instanceOf(RouterTlv.class));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        this.header = new TlvHeader();
        this.header.setTlvType(1);
        this.header.setTlvLength(4);
        this.rtlv = new RouterTlv(this.header);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.rtlv.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.rtlv, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.rtlv, (Matcher)Matchers.instanceOf(RouterTlv.class));
    }

    @Test(expected=Exception.class)
    public void testAsBytes() throws Exception {
        this.result = this.rtlv.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetTlvBodyAsByteArray() throws Exception {
        this.result = this.rtlv.getTlvBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.rtlv.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

