/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.AsbrSummaryLsa;

public class AsbrSummaryLsaTest {
    private final Ip4Address ipAddress = Ip4Address.valueOf((String)"10.226.165.164");
    private AsbrSummaryLsa asbrSummaryLsa;
    private Ip4Address result;
    private int result1;
    private int num;
    private byte[] inputByteArray;
    private byte[] result2;
    private ChannelBuffer channelBuffer;
    private LsaHeader lsaHeader;
    private OspfLsaType ospflsaType;
    private String result3;
    private boolean result4;

    @Before
    public void setUp() throws Exception {
        this.asbrSummaryLsa = new AsbrSummaryLsa(new LsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.asbrSummaryLsa = null;
    }

    @Test
    public void testGetNetworkMask() throws Exception {
        this.asbrSummaryLsa.setNetworkMask(this.ipAddress);
        this.result = this.asbrSummaryLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)this.ipAddress));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.asbrSummaryLsa.setNetworkMask(this.ipAddress);
        this.result = this.asbrSummaryLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)this.ipAddress));
    }

    @Test
    public void testGetMetric() throws Exception {
        this.num = 10;
        this.asbrSummaryLsa.setMetric(this.num);
        this.result1 = this.asbrSummaryLsa.metric();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.num));
    }

    @Test
    public void testSetMetric() throws Exception {
        this.num = 20;
        this.asbrSummaryLsa.setMetric(this.num);
        this.result1 = this.asbrSummaryLsa.metric();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)this.num));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.inputByteArray = this.createByteForNetworkLsa();
        this.lsaHeader = this.createLsaHeader();
        this.asbrSummaryLsa = new AsbrSummaryLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.asbrSummaryLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.asbrSummaryLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        byte[] temp = new byte[]{0, 1, 2, 3};
        this.inputByteArray = temp;
        this.lsaHeader = this.createLsaHeader();
        this.asbrSummaryLsa = new AsbrSummaryLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.asbrSummaryLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.asbrSummaryLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testAsBytes() throws Exception {
        this.result2 = this.asbrSummaryLsa.asBytes();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.result2 = this.asbrSummaryLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.ospflsaType = this.asbrSummaryLsa.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.ASBR_SUMMARY));
    }

    @Test
    public void testToString() throws Exception {
        this.result3 = this.asbrSummaryLsa.toString();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result1 = this.asbrSummaryLsa.hashCode();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testEqual() throws Exception {
        this.result4 = this.asbrSummaryLsa.equals((Object)new AsbrSummaryLsa(new LsaHeader()));
        MatcherAssert.assertThat((Object)this.result4, (Matcher)Matchers.is((Object)true));
    }

    private byte[] createByteForNetworkLsa() {
        byte[] packet = new byte[]{2, 1, 1, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
        return packet;
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(1);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsCheckSum(10);
        this.lsaHeader.setAge(4);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsSequenceNo(250L);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.lsaHeader.setOptions(2);
        return this.lsaHeader;
    }
}

