/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.subtypes.OspfExternalDestination;
import org.onosproject.ospf.protocol.lsa.types.ExternalLsa;

public class ExternalLsaTest {
    private ExternalLsa externalLsa;
    private Vector<OspfExternalDestination> externalDestinations = new Vector();
    private Ip4Address result;
    private OspfExternalDestination ospfExternalDestination;
    private OspfExternalDestination ospfExternalDestination1;
    private LsaHeader lsaHeader;
    private byte[] inputByteArray;
    private ChannelBuffer channelBuffer;
    private byte[] result1;
    private OspfLsaType ospflsaType;
    private int result2;

    @Before
    public void setUp() throws Exception {
        this.externalLsa = new ExternalLsa(new LsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.externalLsa = null;
        this.externalDestinations = null;
        this.result = null;
        this.ospfExternalDestination = null;
        this.ospfExternalDestination1 = null;
        this.lsaHeader = null;
        this.inputByteArray = null;
        this.channelBuffer = null;
        this.result1 = null;
        this.ospflsaType = null;
    }

    @Test
    public void testGetNetworkMask() throws Exception {
        this.externalLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.externalLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.externalLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.externalLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testAddExternalDesitnation() throws Exception {
        this.externalLsa.addExternalDestination(this.createOspfExternalDestination());
        MatcherAssert.assertThat((Object)this.externalLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result2 = this.externalLsa.hashCode();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfExternalDestination = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(2);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination);
        this.ospfExternalDestination1 = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(3);
        this.ospfExternalDestination.setMetric(50);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination1);
        this.ospfExternalDestination.setForwardingAddress(Ip4Address.valueOf((InetAddress)InetAddress.getLocalHost()));
        this.inputByteArray = this.createByteForNetworkLsa();
        this.lsaHeader = this.createLsaHeader();
        this.externalLsa = new ExternalLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.externalLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.externalLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        this.ospfExternalDestination = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(2);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination);
        this.ospfExternalDestination1 = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(3);
        this.ospfExternalDestination.setMetric(50);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination1);
        this.ospfExternalDestination.setForwardingAddress(Ip4Address.valueOf((InetAddress)InetAddress.getLocalHost()));
        byte[] temp = new byte[]{0, 0, 0};
        this.inputByteArray = temp;
        this.lsaHeader = this.createLsaHeader();
        this.externalLsa = new ExternalLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.externalLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.externalLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result1 = this.externalLsa.asBytes();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.ospfExternalDestination = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(2);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination);
        this.ospfExternalDestination1 = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(3);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination1);
        this.result1 = this.externalLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray1() throws Exception {
        this.externalLsa.setNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfExternalDestination = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(2);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination);
        this.ospfExternalDestination1 = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(3);
        this.ospfExternalDestination.setMetric(100);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.externalLsa.addExternalDestination(this.ospfExternalDestination1);
        this.result1 = this.externalLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.ospflsaType = this.externalLsa.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.EXTERNAL_LSA));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.externalLsa.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private byte[] createByteForNetworkLsa() {
        byte[] packet = new byte[]{2, 1, 1, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
        return packet;
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(1);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsCheckSum(10);
        this.lsaHeader.setAge(4);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsSequenceNo(250L);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.lsaHeader.setOptions(2);
        return this.lsaHeader;
    }

    private OspfExternalDestination createOspfExternalDestination() throws UnknownHostException {
        this.ospfExternalDestination = new OspfExternalDestination();
        this.ospfExternalDestination.setExternalRouterTag(1);
        this.ospfExternalDestination.setMetric(10);
        this.ospfExternalDestination.setType1orType2Metric(true);
        this.ospfExternalDestination.setForwardingAddress(Ip4Address.valueOf((InetAddress)InetAddress.getLocalHost()));
        return this.ospfExternalDestination;
    }
}

