/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import java.net.InetAddress;
import java.util.Vector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;

public class NetworkLsaTest {
    private Vector<String> attachedRouters = new Vector();
    private NetworkLsa networkLsa;
    private Ip4Address result;
    private Ip4Address inetAddres;
    private byte[] inputByteArray;
    private LsaHeader lsaHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result1;
    private OspfLsaType ospflsaType;
    private int result2;

    @Before
    public void setUp() throws Exception {
        this.networkLsa = new NetworkLsa();
    }

    @After
    public void tearDown() throws Exception {
        this.networkLsa = null;
        this.attachedRouters = null;
        this.result = null;
        this.inetAddres = null;
        this.inputByteArray = null;
        this.lsaHeader = null;
        this.channelBuffer = null;
        this.result1 = null;
        this.ospflsaType = null;
    }

    @Test
    public void testGetNetworkMask() throws Exception {
        this.networkLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.networkLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.networkLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.165"));
        this.result = this.networkLsa.networkMask();
        this.result = this.networkLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.165")));
    }

    @Test
    public void testGetAttachedRouters() throws Exception {
        this.attachedRouters.add("1.1.1.1");
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat(this.attachedRouters, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetAttachedRouters() throws Exception {
        this.attachedRouters.add("1.1.1.1");
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat(this.attachedRouters, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddAttachedRouter() throws Exception {
        this.inetAddres = Ip4Address.valueOf((InetAddress)InetAddress.getLocalHost());
        this.networkLsa.addAttachedRouter(this.inetAddres);
        this.inetAddres = Ip4Address.valueOf((InetAddress)InetAddress.getLocalHost());
        this.networkLsa.addAttachedRouter(this.inetAddres);
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.inputByteArray = this.createByteForNetworkLsa();
        this.lsaHeader = this.createLsaHeader();
        this.networkLsa = new NetworkLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.networkLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        byte[] temp = new byte[]{0, 0, 0};
        this.inputByteArray = temp;
        this.lsaHeader = this.createLsaHeader();
        this.networkLsa = new NetworkLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.networkLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testAsBytes() throws Exception {
        this.result1 = this.networkLsa.asBytes();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"2.2.2.2"));
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"3.3.3.3"));
        this.result1 = this.networkLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray1() throws Exception {
        this.networkLsa.setNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"2.2.2.2"));
        this.networkLsa.addAttachedRouter(Ip4Address.valueOf((String)"3.3.3.3"));
        this.result1 = this.networkLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.networkLsa.setLsType(2);
        this.ospflsaType = this.networkLsa.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.NETWORK));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result2 = this.networkLsa.hashCode();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private byte[] createByteForNetworkLsa() {
        byte[] packet = new byte[]{2, 1, 1, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
        return packet;
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(2);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsCheckSum(10);
        this.lsaHeader.setAge(4);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsSequenceNo(250L);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.lsaHeader.setOptions(2);
        return this.lsaHeader;
    }
}

