/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.tlvtypes.LinkTlv;
import org.onosproject.ospf.protocol.lsa.tlvtypes.RouterTlv;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.TopLevelTlv;

public class OpaqueLsa10Test {
    private final byte[] packet = new byte[]{0, 1, 0, 4, 1, 1, 1, 1, 0, 2, 0, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private OpaqueLsa10 opaqueLsa10;
    private TopLevelTlv tlv;
    private OpaqueLsaHeader opqueHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result;
    private RouterTlv routerTlv;
    private RouterTlv routerTlv1;
    private LinkTlv linkTlv;
    private LinkTlv linkTlv1;
    private OspfLsaType ospflsaType;
    private int result1;
    private List result2;

    @Before
    public void setUp() throws Exception {
        this.opaqueLsa10 = new OpaqueLsa10(new OpaqueLsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.opaqueLsa10 = null;
        this.tlv = null;
        this.opqueHeader = null;
        this.channelBuffer = null;
        this.result = null;
        this.routerTlv = null;
        this.routerTlv1 = null;
        this.linkTlv1 = null;
        this.ospflsaType = null;
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.opaqueLsa10.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddValue() throws Exception {
        this.tlv = new RouterTlv(new TlvHeader());
        this.opaqueLsa10.addValue(this.tlv);
        MatcherAssert.assertThat((Object)this.opaqueLsa10, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(10);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(10);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(66);
        this.opaqueLsa10 = new OpaqueLsa10(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa10.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa10.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testAsBytes() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(10);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(10);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(66);
        this.opaqueLsa10 = new OpaqueLsa10(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa10.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa10.getLsaBodyAsByteArray();
        this.result = this.opaqueLsa10.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(10);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(10);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa10 = new OpaqueLsa10(this.opqueHeader);
        this.routerTlv = new RouterTlv(new TlvHeader());
        this.linkTlv = new LinkTlv(new TlvHeader());
        this.opaqueLsa10.addValue((TopLevelTlv)this.routerTlv);
        this.opaqueLsa10.addValue((TopLevelTlv)this.linkTlv);
        this.routerTlv1 = new RouterTlv(new TlvHeader());
        this.linkTlv1 = new LinkTlv(new TlvHeader());
        this.opaqueLsa10.addValue((TopLevelTlv)this.routerTlv1);
        this.opaqueLsa10.addValue((TopLevelTlv)this.linkTlv1);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa10.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa10.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetLsaBodyAsByteArray1() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(10);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(10);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa10 = new OpaqueLsa10(this.opqueHeader);
        this.routerTlv = new RouterTlv(new TlvHeader());
        this.opaqueLsa10.addValue((TopLevelTlv)this.routerTlv);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.result = this.opaqueLsa10.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetLsaBodyAsByteArray2() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(10);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(10);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa10 = new OpaqueLsa10(this.opqueHeader);
        this.linkTlv = new LinkTlv(new TlvHeader());
        this.opaqueLsa10.addValue((TopLevelTlv)this.linkTlv);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa10.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa10.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.opaqueLsa10.setLsType(10);
        this.ospflsaType = this.opaqueLsa10.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.AREA_LOCAL_OPAQUE_LSA));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result1 = this.opaqueLsa10.hashCode();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testTopLevelValues() throws Exception {
        this.result2 = this.opaqueLsa10.topLevelValues();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

