/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa11;

public class OpaqueLsa11Test {
    private final byte[] packet = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private OpaqueLsa11 opaqueLsa11;
    private OpaqueLsaHeader opqueHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result;
    private int result1;
    private String result2;
    private OspfLsaType ospflsaType;

    @Before
    public void setUp() throws Exception {
        this.opaqueLsa11 = new OpaqueLsa11(new OpaqueLsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.opaqueLsa11 = null;
        this.opqueHeader = null;
        this.channelBuffer = null;
        this.result = null;
        this.ospflsaType = null;
    }

    @Test
    public void testReadFrom() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(11);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(11);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa11 = new OpaqueLsa11(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa11.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.opaqueLsa11, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(11);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(11);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa11 = new OpaqueLsa11(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa11.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa11.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(11);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(1);
        this.opqueHeader.setOpaqueType(11);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa11 = new OpaqueLsa11(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa11.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa11.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.opaqueLsa11.setLsType(11);
        this.ospflsaType = this.opaqueLsa11.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.AS_OPAQUE_LSA));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result1 = this.opaqueLsa11.hashCode();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        this.result2 = this.opaqueLsa11.toString();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

